/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.filters;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;

public class FragmentVisibility
extends StandaloneFilter {
    private static final Log log = LogFactory.getLog(FragmentVisibility.class);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        Element element = info.getElement();
        if (element instanceof Fragment) {
            String viewMode = info.getViewMode();
            if (viewMode != null && viewMode.startsWith("area-styles")) {
                return null;
            }
            Fragment fragment = (Fragment)element;
            PerspectiveType perspective = ThemeManager.getPerspectiveByUrl((URL)info.getThemeUrl());
            FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
            Format format = ElementFormatter.getFormatByType((Object)fragment, (FormatType)widgetType);
            if (format == null) {
                return info;
            }
            boolean visible = true;
            if (perspective != null && !fragment.isVisibleInPerspective(perspective)) {
                visible = false;
            }
            if ("fragment".equals(viewMode) || "layout".equals(viewMode)) {
                StringBuilder content = new StringBuilder();
                if (visible) {
                    content.append("<div class=\"nxthemesFragment\">");
                } else {
                    content.append("<div class=\"nxthemesFragmentHidden\">");
                }
                String description = fragment.getDescription();
                if (description != null) {
                    content.append(String.format("<div><b>%s</b></div>", description));
                }
                content.append(String.format("%s / %s", fragment.getFragmentType().getTypeName(), format.getName()));
                content.append("</div>");
                info.setMarkup(content.toString());
                return info;
            }
            if (!visible) {
                return null;
            }
        } else {
            log.warn((Object)"The 'fragment visibility' filter can only be applied to fragments.");
        }
        return info;
    }
}

