/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.listener.action.AbstractMailAction;

public class CreateDocumentsAction
extends AbstractMailAction {
    private static final Log log = LogFactory.getLog(CreateDocumentsAction.class);

    public boolean execute(ExecutionContext context) throws Exception {
        CoreSession session = this.getCoreSession(context);
        if (session == null) {
            log.error((Object)"Could not open CoreSession");
            return false;
        }
        ExecutionContext initialContext = context.getInitialContext();
        String subject = (String)context.get("subject");
        String sender = (String)context.get("sender");
        Date sendingDate = (Date)context.get("sendingDate");
        ArrayList recipients = (ArrayList)context.get("recipients");
        ArrayList ccRecipients = (ArrayList)context.get("ccRecipients");
        List attachments = (List)context.get("attachments");
        String text = (String)context.get("text");
        String parentPath = (String)initialContext.get("parentPath");
        DocumentModel documentModel = session.createDocumentModel(parentPath, IdUtils.generateId((String)(subject + System.currentTimeMillis())), "MailMessage");
        documentModel.setPropertyValue("dc:title", (Serializable)((Object)subject));
        documentModel.setPropertyValue("mail:sender", (Serializable)((Object)sender));
        documentModel.setPropertyValue("mail:sending_date", (Serializable)sendingDate);
        documentModel.setPropertyValue("mail:recipients", (Serializable)recipients);
        documentModel.setPropertyValue("mail:cc_recipients", (Serializable)ccRecipients);
        if (attachments != null && !attachments.isEmpty()) {
            ArrayList files = new ArrayList();
            for (FileBlob currentFileBlob : attachments) {
                if (currentFileBlob == null) continue;
                HashMap<String, Object> file = new HashMap<String, Object>();
                file.put("file", currentFileBlob);
                file.put("filename", currentFileBlob.getFilename());
                files.add(file);
            }
            documentModel.setPropertyValue("files:files", files);
        }
        documentModel.setPropertyValue("mail:cc_recipients", (Serializable)ccRecipients);
        documentModel.setPropertyValue("mail:text", (Serializable)((Object)text));
        UnrestrictedCreateDocument unrestrictedCreateDocument = new UnrestrictedCreateDocument(documentModel, session);
        unrestrictedCreateDocument.runUnrestricted();
        return true;
    }

    public void reset(ExecutionContext context) throws Exception {
    }

    protected class UnrestrictedCreateDocument
    extends UnrestrictedSessionRunner {
        private DocumentModel document;

        protected UnrestrictedCreateDocument(DocumentModel document, CoreSession session) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            this.document = this.session.createDocument(this.document);
            this.document = this.session.saveDocument(this.document);
            this.session.save();
        }
    }
}

