/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forum.web.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.platform.forum.web.api.ThreadAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadAdapterImpl
implements ThreadAdapter,
Serializable {
    private static final long serialVersionUID = 1876878787587L;
    private final DocumentModel threadDoc;
    private List<DocumentModel> posts;
    private List<DocumentModel> publishedPosts;
    private List<DocumentModel> pendingPosts;
    private DocumentModel lastPublishedPost;

    public ThreadAdapterImpl(DocumentModel threadDoc) {
        this.threadDoc = threadDoc;
    }

    private void fetchAllPosts() throws ClientException {
        this.posts = this.getSubComments(this.threadDoc);
    }

    @Override
    public List<DocumentModel> getAllPosts() throws ClientException {
        if (this.posts == null) {
            this.fetchAllPosts();
        }
        return this.posts;
    }

    @Override
    public List<DocumentModel> getPublishedPosts() throws ClientException {
        if (this.publishedPosts == null) {
            this.publishedPosts = new ArrayList<DocumentModel>();
            for (DocumentModel doc : this.getAllPosts()) {
                if (!"moderation_published".equals(doc.getCurrentLifeCycleState())) continue;
                this.publishedPosts.add(doc);
            }
        }
        return this.publishedPosts;
    }

    @Override
    public List<DocumentModel> getPendingPosts() throws ClientException {
        if (this.pendingPosts == null) {
            this.pendingPosts = new ArrayList<DocumentModel>();
            for (DocumentModel doc : this.getAllPosts()) {
                if (!"moderation_pending".equals(doc.getCurrentLifeCycleState())) continue;
                this.pendingPosts.add(doc);
            }
        }
        return this.pendingPosts;
    }

    @Override
    public DocumentModel getLastPublishedPost() throws ClientException {
        if (this.lastPublishedPost == null) {
            GregorianCalendar lastPostDate = null;
            for (DocumentModel post : this.getPublishedPosts()) {
                GregorianCalendar postDate = (GregorianCalendar)post.getProperty("post", "creationDate");
                if (lastPostDate != null && !postDate.after(lastPostDate)) continue;
                lastPostDate = postDate;
                this.lastPublishedPost = post;
            }
        }
        return this.lastPublishedPost;
    }

    protected List<DocumentModel> getSubComments(DocumentModel doc) throws ClientException {
        ArrayList<DocumentModel> allSubPosts = new ArrayList<DocumentModel>();
        CommentableDocument commentDoc = (CommentableDocument)doc.getAdapter(CommentableDocument.class);
        if (commentDoc != null) {
            List childComments = commentDoc.getComments();
            for (DocumentModel childComment : childComments) {
                allSubPosts.add(childComment);
                allSubPosts.addAll(this.getSubComments(childComment));
            }
        }
        return allSubPosts;
    }

    @Override
    public DocumentModel getThreadDoc() {
        return this.threadDoc;
    }
}

