/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TaggingHelper;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="tagActions")
@Scope(value=ScopeType.CONVERSATION)
public class TagActionsBean
implements Serializable {
    public static final String TAG_SEARCH_RESULT_PAGE = "tag_search_results";
    private static final long serialVersionUID = -630033792577162398L;
    private static final Log log = LogFactory.getLog(TagActionsBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    protected TaggingHelper taggingHelper;
    protected String tagDocumentId;
    private String tagsLabel;
    private Boolean addTag;

    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing 'tagActions' Seam component ...");
        this.taggingHelper = new TaggingHelper();
    }

    @Destroy
    public void destroy() {
        log.debug((Object)"Removing 'tagActions' Seam component...");
    }

    @Factory(value="tagServiceEnabled", scope=ScopeType.APPLICATION)
    public boolean isTagServiceEnabled() throws ClientException {
        return this.taggingHelper.isTagServiceEnabled();
    }

    @Factory(value="currentDocumentTags", scope=ScopeType.EVENT)
    public List<Tag> getDocumentTags() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return new ArrayList<Tag>();
        }
        if (currentDocument.isProxy()) {
            DocumentModel targetDocument = this.documentManager.getDocument((DocumentRef)new IdRef(currentDocument.getSourceId()));
            return this.taggingHelper.listDocumentTags(this.documentManager, targetDocument);
        }
        return this.taggingHelper.listDocumentTags(this.documentManager, currentDocument);
    }

    public String addTagging() throws ClientException {
        String messageKey;
        this.tagsLabel = TagActionsBean.cleanTag(this.tagsLabel);
        if (StringUtils.isBlank((String)this.tagsLabel)) {
            messageKey = "message.add.new.tagging.not.empty";
        } else {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.taggingHelper.addTagging(this.documentManager, currentDocument, this.tagsLabel);
            messageKey = "message.add.new.tagging";
            Contexts.getEventContext().remove("currentDocumentTags");
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(messageKey), new Object[]{this.tagsLabel});
        this.reset();
        return null;
    }

    public String removeTagging(String taggingId) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String deletedTagLabel = taggingId;
        try {
            DocumentModel tagToDelete = this.documentManager.getDocument((DocumentRef)new IdRef(taggingId));
            deletedTagLabel = (String)((Object)tagToDelete.getPropertyValue("tag:label"));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to find deleted tag label", (Throwable)e);
        }
        this.taggingHelper.removeTagging(this.documentManager, currentDocument, taggingId);
        this.reset();
        Contexts.getEventContext().remove("currentDocumentTags");
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("message.remove.tagging"), new Object[]{deletedTagLabel});
        return null;
    }

    public List<WeightedTag> getPopularCloud() throws ClientException {
        ArrayList<WeightedTag> tagCloud = new ArrayList<WeightedTag>();
        int max = 0;
        int min = 0;
        for (DocumentModel document : this.documentManager.getChildren(this.documentManager.getRootDocument().getRef())) {
            for (WeightedTag weightedTag : this.taggingHelper.getPopularCloud(this.documentManager, document)) {
                if (weightedTag.getWeight() > max) {
                    max = weightedTag.getWeight();
                }
                if (weightedTag.getWeight() < min) {
                    min = weightedTag.getWeight();
                }
                tagCloud.add(weightedTag);
            }
        }
        for (WeightedTag tag : tagCloud) {
            tag.setWeight((int)Math.round(150.0 * (1.0 + (1.5 * (double)tag.getWeight() - (double)(min / 2)) / (double)max)) / 2);
        }
        return tagCloud;
    }

    @Factory(value="tagCloudOnAllDocuments", scope=ScopeType.EVENT)
    public List<WeightedTag> getPopularCloudOnAllDocuments() throws ClientException {
        ArrayList<WeightedTag> tagCloud = new ArrayList<WeightedTag>();
        int max = 0;
        int min = 0;
        for (WeightedTag weightedTag : this.taggingHelper.getPopularCloudOnAllDocuments(this.documentManager)) {
            if (weightedTag.getWeight() > max) {
                max = weightedTag.getWeight();
            }
            if (weightedTag.getWeight() < min) {
                min = weightedTag.getWeight();
            }
            tagCloud.add(weightedTag);
        }
        for (WeightedTag tag : tagCloud) {
            tag.setWeight((int)Math.round(150.0 * (1.0 + (1.5 * (double)tag.getWeight() - (double)(min / 2)) / (double)max)) / 2);
        }
        return tagCloud;
    }

    public String listDocumentsForTag(String tagDocumentId) throws ClientException {
        this.tagDocumentId = tagDocumentId;
        return TAG_SEARCH_RESULT_PAGE;
    }

    @Factory(value="taggedDocuments", scope=ScopeType.EVENT)
    public DocumentModelList getChildrenSelectModel() throws ClientException {
        DocumentModelListImpl taggedDocuments = new DocumentModelListImpl();
        if (!StringUtils.isBlank((String)this.tagDocumentId)) {
            taggedDocuments.addAll((Collection)this.taggingHelper.listDocumentsForTag(this.documentManager, this.tagDocumentId));
        }
        return taggedDocuments;
    }

    public boolean canModifyTag(Tag tag) throws ClientException {
        return this.taggingHelper.canModifyTag(this.documentManager, this.navigationContext.getCurrentDocument(), tag);
    }

    public void reset() {
        this.tagsLabel = null;
    }

    public void showAddTag(ActionEvent event) {
        if (this.addTag == null) {
            this.addTag = Boolean.FALSE;
        }
        this.addTag = this.addTag == false;
    }

    public String getTagsLabel() {
        return this.tagsLabel;
    }

    public void setTagsLabel(String tagsLabel) {
        this.tagsLabel = tagsLabel;
    }

    public Boolean getAddTag() {
        return this.addTag;
    }

    public void setAddTag(Boolean addTag) {
        this.addTag = addTag;
    }

    public Object getSuggestions(Object input) throws ClientException {
        String searchPattern = (String)input;
        searchPattern = TagActionsBean.cleanTag(searchPattern);
        ArrayList result = new ArrayList();
        String query = String.format("SELECT * FROM Tag WHERE tag:label LIKE '%s%%' ORDER BY tag:label", searchPattern);
        DocumentModelList tags = this.documentManager.query(query);
        for (DocumentModel tag : tags) {
            Serializable label = tag.getPropertyValue("tag:label");
            HashMap<String, Serializable> entry = new HashMap<String, Serializable>();
            entry.put("id", label);
            entry.put("label", label);
            result.add(entry);
            if (result.size() <= 10) continue;
            break;
        }
        return result;
    }

    protected static String cleanTag(String tag) {
        tag = tag.toLowerCase();
        tag = tag.replaceAll(" +", " ");
        tag = tag.trim();
        tag = tag.replace("\\", "");
        tag = tag.replace("'", "");
        tag = tag.replace("%", "");
        return tag;
    }

    @Observer(value={"documentSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void documentChanged() {
        this.addTag = false;
    }
}

