/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.HtmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(Html2TextConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        InputStream stream = null;
        try {
            stream = blobHolder.getBlob().getStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            HtmlParser parser = new HtmlParser();
            SAXResult result = new SAXResult(new DefaultHandler());
            SAXSource source = new SAXSource((XMLReader)((Object)parser), new InputSource(stream));
            transformer.transform(source, result);
            String text = parser.getContents();
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(text, "text/plain"));
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during Html2Text conversion", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing Blob stream", (Throwable)e);
                }
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

