/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;
import org.pdfbox.util.PDFTextStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDF2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(PDF2TextConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        PDDocument document = null;
        File f = null;
        OutputStream fas = null;
        try {
            document = PDDocument.load((InputStream)blobHolder.getBlob().getStream());
            PDFTextStripper textStripper = new PDFTextStripper();
            Boolean isReadable = true;
            PDEncryptionDictionary encDictionary = document.getEncryptionDictionary();
            if (encDictionary instanceof PDStandardEncryption && !document.wasDecryptedWithOwnerPassword()) {
                PDStandardEncryption stdEncryption = (PDStandardEncryption)encDictionary;
                isReadable = stdEncryption.canExtractContent();
            }
            if (isReadable.booleanValue()) {
                f = File.createTempFile("pdfboplugin", ".txt");
                fas = new FileOutputStream(f);
                byte[] bytes = textStripper.getText(document).getBytes();
                fas.write(bytes);
                SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new FileBlob((InputStream)new FileInputStream(f)));
                return simpleCachableBlobHolder;
            }
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(""));
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error dring text extraction with PDFBox", e);
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing PDFBox document", (Throwable)e);
                }
            }
            if (fas != null) {
                try {
                    fas.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (f != null) {
                f.delete();
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

