/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XL2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(XL2TextConverter.class);
    private static final String CELL_SEP = "";
    private static final String ROW_SEP = "\n";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        InputStream stream = null;
        StringBuffer sb = new StringBuffer();
        try {
            stream = blobHolder.getBlob().getStream();
            POIFSFileSystem fs = new POIFSFileSystem(stream);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    Iterator cells = row.cellIterator();
                    while (cells.hasNext()) {
                        HSSFCell cell = (HSSFCell)cells.next();
                        this.appendTextFromCell(cell, sb);
                    }
                    sb.append(ROW_SEP);
                }
            }
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(sb.toString()));
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during XL2Text conversion", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing Blob stream", (Throwable)e);
                }
            }
        }
    }

    protected void appendTextFromCell(HSSFCell cell, StringBuffer sb) {
        String cellValue = null;
        switch (cell.getCellType()) {
            case 0: {
                cellValue = Double.toString(cell.getNumericCellValue()).trim();
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue().trim();
            }
        }
        if (cellValue != null && cellValue.length() > 0) {
            sb.append(cellValue).append(CELL_SEP);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

