/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.api;

import java.util.Collection;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceProvider;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpaceProvider
implements SpaceProvider {
    @Override
    public void add(Space o, CoreSession session) throws SpaceException {
        if (this.isReadOnly(session)) {
            throw new SpaceException("This SpaceProvider is read only");
        }
    }

    @Override
    public void addAll(Collection<? extends Space> c, CoreSession session) throws SpaceException {
        if (this.isReadOnly(session)) {
            throw new SpaceException("This SpaceProvider is read only");
        }
    }

    @Override
    public void clear(CoreSession session) throws SpaceException {
        if (this.isReadOnly(session)) {
            throw new SpaceException("This SpaceProvider is read only");
        }
    }

    @Override
    public final Space getSpace(String spaceName, CoreSession session) throws SpaceException {
        Space result = this.doGetSpace(spaceName, session);
        if (result == null) {
            throw new SpaceNotFoundException();
        }
        return result;
    }

    @Override
    public boolean isEmpty(CoreSession session) throws SpaceException {
        return this.getAll(session).size() == 0;
    }

    @Override
    public long size(CoreSession session) throws SpaceException {
        return this.getAll(session).size();
    }

    protected abstract Space doGetSpace(String var1, CoreSession var2) throws SpaceException;

    @Override
    public void initialize(Map<String, String> params) throws Exception {
    }

    @Override
    public boolean remove(Space space, CoreSession session) throws SpaceException {
        if (this.isReadOnly(session)) {
            throw new SpaceException("This SpaceProvider is read only");
        }
        return false;
    }
}

