/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsConstants;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.annotations.service.AnnotationConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.AnnotationIDGenerator;
import org.nuxeo.ecm.platform.annotations.service.AnnotationQuery;
import org.nuxeo.ecm.platform.annotations.service.MetadataMapper;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsServiceImpl
implements AnnotationsService {
    private static final String GET_ANN_QUERY = "SELECT ?p ?o WHERE { <source> ?p ?o .}";
    private final RelationManager relationManager;
    private final AnnotationConfigurationService configuration;
    private final AnnotationIDGenerator idGenerator;
    private final MetadataMapper mapper;
    private final UriResolver resolver;
    private final AnnotationManager annotationManager = new AnnotationManager();

    public AnnotationsServiceImpl() throws Exception {
        this.relationManager = (RelationManager)Framework.getService(RelationManager.class);
        this.configuration = (AnnotationConfigurationService)Framework.getService(AnnotationConfigurationService.class);
        this.idGenerator = this.configuration.getIDGenerator();
        this.mapper = this.configuration.getMetadataMapper();
        this.resolver = this.configuration.getUriResolver();
    }

    public Annotation addAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        String id = this.idGenerator.getNext();
        return this.addAnnotation(annotation, user, baseUrl, id);
    }

    private Annotation addAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl, String id) throws AnnotationException {
        try {
            Graph graph = this.relationManager.getGraphByName("annotations");
            ResourceImpl resource = new ResourceImpl("urn:annotation:" + id);
            annotation.setSubject((Resource)resource);
            this.mapper.updateMetadata(annotation, user);
            graph.add(annotation.getStatements());
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
        return annotation;
    }

    public void deleteAnnotation(Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        try {
            Graph graph = this.relationManager.getGraphByName("annotations");
            graph.remove(annotation.getStatements());
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
    }

    public void deleteAnnotationFor(URI uri, Annotation annotation, NuxeoPrincipal user) throws AnnotationException {
        ArrayList<Statement> statementsToDelete = new ArrayList<Statement>();
        boolean removeAllAnnotationStatements = true;
        List statements = annotation.getStatements();
        for (Statement statement : statements) {
            if (!statement.getPredicate().equals(AnnotationsConstants.a_annotates)) continue;
            Resource resource = (Resource)statement.getObject();
            if (uri.toString().equals(resource.getUri())) {
                statementsToDelete.add(statement);
                continue;
            }
            removeAllAnnotationStatements = false;
        }
        if (removeAllAnnotationStatements) {
            statementsToDelete.addAll(annotation.getStatements());
        }
        Graph graph = this.getAnnotationGraph();
        graph.remove(statementsToDelete);
    }

    public Annotation getAnnotation(String id, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        Annotation annotation = null;
        String uri = "urn:annotation:" + id;
        String query = GET_ANN_QUERY.replaceFirst("source", uri);
        try {
            Graph graph = this.relationManager.getGraphByName("annotations");
            QueryResult result = graph.query(query, "sparql", null);
            ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>();
            for (Map map : result.getResults()) {
                StatementImpl statement = new StatementImpl((Node)new ResourceImpl(uri), (Node)map.get("p"), (Node)map.get("o"));
                statements.add(statement);
            }
            annotation = this.annotationManager.getAnnotation(statements);
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
        return annotation;
    }

    public String getAnnotationBody(String id, NuxeoPrincipal name) throws AnnotationException {
        String uri = "urn:annotation:body/" + id;
        try {
            Graph graph = this.relationManager.getGraphByName("annotations");
            List result = graph.getObjects((Node)new ResourceImpl(uri), (Node)AnnotationsConstants.nx_body_content);
            return ((Literal)result.get(0)).getValue();
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
    }

    public List<Annotation> queryAnnotations(URI uri, Map<String, String> filters, NuxeoPrincipal user) throws AnnotationException {
        AnnotationQuery query = new AnnotationQuery();
        Graph graph = null;
        try {
            graph = this.relationManager.getGraphByName("annotations");
        }
        catch (ClientException e) {
            throw new AnnotationException((Throwable)e);
        }
        List uris = this.resolver.getSearchURI(uri);
        List<Annotation> annotations = query.getAnnotationsForURIs(uris, graph, filters);
        return annotations;
    }

    public Annotation updateAnnotation(Annotation annotation, NuxeoPrincipal user, String baseUrl) throws AnnotationException {
        try {
            String id = annotation.getId();
            this.deleteAnnotation(annotation, user);
            return this.addAnnotation(annotation, user, baseUrl, id);
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
    }

    public Graph getAnnotationGraph() throws AnnotationException {
        try {
            return this.relationManager.getGraphByName("annotations");
        }
        catch (ClientException e) {
            throw new AnnotationException((Throwable)e);
        }
    }
}

