/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUriResolver
implements UriResolver {
    private static final String NUXEO_ANNOTATIONS = "nuxeo/Annotations/";

    public String getBaseUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            String url = uri.toURL().toString();
            if (url.contains(NUXEO_ANNOTATIONS)) {
                return url.substring(0, url.indexOf(NUXEO_ANNOTATIONS) + NUXEO_ANNOTATIONS.length());
            }
            return url.substring(0, url.indexOf("nuxeo") + "nuxeo".length());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public List<URI> getSearchURI(URI uri) throws AnnotationException {
        return Collections.singletonList(uri);
    }

    public URI translateFromGraphURI(URI uri, String baseUrl) throws AnnotationException {
        if (uri.toString().startsWith("urn:annotation:")) {
            String annId = uri.toString().substring(uri.toString().lastIndexOf(":") + 1);
            try {
                return new URI(baseUrl + annId);
            }
            catch (URISyntaxException e) {
                throw new AnnotationException((Throwable)e);
            }
        }
        return uri;
    }

    public URI translateToGraphURI(URI uri) throws AnnotationException {
        String path = uri.getPath();
        if (uri.toString().contains(NUXEO_ANNOTATIONS)) {
            try {
                return new URI("urn:annotation:" + path.substring(path.lastIndexOf("/") + 1));
            }
            catch (URISyntaxException e) {
                throw new AnnotationException((Throwable)e);
            }
        }
        return uri;
    }
}

