/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPatternFilter {
    private final boolean allowDeny;
    private final List<String> denies;
    private final List<String> allows;

    public URLPatternFilter(boolean allowDeny, List<String> denies, List<String> allows) {
        this.allowDeny = allowDeny;
        this.denies = denies;
        this.allows = allows;
    }

    public boolean allow(String url) {
        if (this.checkFirstPass(url) && !this.checkSecondPass(url)) {
            return this.allowDeny;
        }
        return !this.allowDeny;
    }

    private boolean checkSecondPass(String url) {
        return URLPatternFilter.checkMatch(this.allowDeny ? this.denies : this.allows, url);
    }

    private static boolean checkMatch(List<String> list, String url) {
        for (String regex : list) {
            if (!url.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFirstPass(String url) {
        return URLPatternFilter.checkMatch(this.allowDeny ? this.allows : this.denies, url);
    }
}

