/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen.corelistener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.uidgen.service.ServiceHelper;
import org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorService;

public class DocUIDGeneratorListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DocUIDGeneratorListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            String eventId = event.getName();
            if (!eventId.equals("documentCreated")) {
                return;
            }
            log.debug((Object)("eventId : " + eventId));
            try {
                DocUIDGeneratorListener.addUIDtoDoc(doc);
            }
            catch (DocumentException e) {
                log.error((Object)("Error occurred while generating UID for doc: " + doc), (Throwable)e);
            }
        }
    }

    private static void addUIDtoDoc(DocumentModel doc) throws DocumentException {
        UIDGeneratorService service = ServiceHelper.getUIDGeneratorService();
        if (service == null) {
            log.error((Object)"<addUIDtoDoc> UIDGeneratorService service not found ... !");
            return;
        }
        service.setUID(doc);
    }
}

