/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.backend.indexing.resources.factory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.LazyBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedData;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResource;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.factory.BuiltinDocumentFields;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl.ResolvedDataImpl;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl.ResolvedResourceImpl;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl.ResolvedResourcesImpl;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.indexing.blobs.BlobExtractor;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResources;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.DocumentIndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.factory.IndexableResourceFactory;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceDataConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.ResourceTypeDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.FulltextFieldDescriptor;

public class ResolvedResourcesFactory {
    private static final Log log = LogFactory.getLog(ResolvedResourcesFactory.class);
    private static SearchService service;

    private ResolvedResourcesFactory() {
    }

    public static void reInitSearchService() {
        service = null;
    }

    private static SearchService getSearchService() {
        if (service == null) {
            service = SearchServiceDelegate.getRemoteSearchService();
        }
        return service;
    }

    private static ResolvedData computeFulltext(IndexableResources resources) {
        String value = "";
        String analyzer = "default";
        String type = "text";
        SearchService service = ResolvedResourcesFactory.getSearchService();
        if (service != null) {
            String prefixedName = BuiltinDocumentFields.getPrefixedNameFor("ecm:fulltext");
            FulltextFieldDescriptor desc = ResolvedResourcesFactory.getSearchService().getFullTextDescriptorByName(prefixedName);
            if (desc != null) {
                analyzer = desc.getAnalyzer();
                List<String> resourceFields = desc.getResourceFields();
                ArrayList<String> extracted = new ArrayList<String>(resourceFields.size());
                for (String field : resourceFields) {
                    extracted.add(ResolvedResourcesFactory.extractForFullText(resources, desc, field));
                }
                value = StringUtils.join(extracted, (String)" ");
            } else {
                log.warn((Object)"No fulltext descriptor found for name=ecm:fulltext");
            }
        }
        return new ResolvedDataImpl("ecm:fulltext", analyzer, type, value, false, true, false, false, null, null, false, null);
    }

    private static String extractForFullText(IndexableResources resources, FulltextFieldDescriptor desc, String field) {
        String[] sfield = field.split(":", 2);
        if (sfield.length < 2) {
            log.warn((Object)("Discarding field conf for fulltext. Invalid syntax :" + field));
            return "";
        }
        String resourceName = sfield[0].trim();
        String dataKeyName = sfield[1].trim();
        if ("*".equals(resourceName) && "*".equals(dataKeyName)) {
            return ResolvedResourcesFactory.extractAllForFullText(desc, resources);
        }
        if ("*".equals(dataKeyName)) {
            return ResolvedResourcesFactory.extractAllForFullText(resourceName, desc, resources);
        }
        Serializable ob = null;
        IndexableResource resource = resources.getIndexableResources().get(0);
        try {
            ob = resource.getValueFor(resourceName + ':' + dataKeyName);
        }
        catch (IndexingException ie) {
            log.warn((Object)("Got an exception while retrieving " + field + "on " + resource.toString()));
            return "";
        }
        if (ob == null) {
            return "";
        }
        return ResolvedResourcesFactory.convertForFullText(ob, desc, resources);
    }

    public static String extractAllForFullText(String resourceName, FulltextFieldDescriptor desc, IndexableResources resources) {
        for (IndexableResource resource : resources.getIndexableResources()) {
            if (!resourceName.equals(resource.getConfiguration().getName())) continue;
            return ResolvedResourcesFactory.extractAllForFullText(desc, resource, resources);
        }
        log.debug((Object)("Resource '" + resourceName + "' not found on " + resources));
        return "";
    }

    public static String extractAllForFullText(FulltextFieldDescriptor desc, IndexableResource resource, IndexableResources resources) {
        LinkedList<String> res = new LinkedList<String>();
        Map<String, IndexableResourceDataConf> fieldMap = resource.getConfiguration().getIndexableFields();
        for (String fieldName : fieldMap.keySet()) {
            Serializable v;
            String type = fieldMap.get(fieldName).getIndexingType();
            if (type == null || !"text".equals(type = type.toLowerCase()) && !"keyword".equals(type)) continue;
            try {
                v = resource.getValueFor(resource.getName() + ":" + fieldName);
            }
            catch (IndexingException e) {
                log.warn((Object)String.format("could not get value of %s on %s", fieldName, resource.toString()), (Throwable)e);
                continue;
            }
            if (v == null) continue;
            res.add(ResolvedResourcesFactory.convertForFullText(v, desc, resources));
        }
        return StringUtils.join(res, (String)" ");
    }

    public static String extractAllForFullText(FulltextFieldDescriptor desc, IndexableResources resources) {
        LinkedList<String> res = new LinkedList<String>();
        for (IndexableResource resource : resources.getIndexableResources()) {
            if (resource.getConfiguration().getType().equals("documentBuiltins")) continue;
            res.add(ResolvedResourcesFactory.extractAllForFullText(desc, resource, resources));
        }
        return StringUtils.join(res, (String)" ");
    }

    private static String convertForFullText(Serializable ob, FulltextFieldDescriptor desc, IndexableResources resources) {
        if (ob instanceof String) {
            return (String)((Object)ob);
        }
        if (ob instanceof Blob) {
            Blob blob = (Blob)ob;
            return ResolvedResourcesFactory.blobToText(blob, desc, resources);
        }
        if (ob instanceof List) {
            List l = (List)((Object)ob);
            ArrayList<String> res = new ArrayList<String>(l.size());
            for (Serializable i : l) {
                res.add(ResolvedResourcesFactory.convertForFullText(i, desc, resources));
            }
            return StringUtils.join(res, (String)" ");
        }
        if (ob instanceof String[]) {
            return StringUtils.join((Object[])((String[])ob), (String)" ");
        }
        return "";
    }

    private static String blobToText(Blob blob, FulltextFieldDescriptor desc, IndexableResources resources) {
        String mimeType = blob.getMimeType();
        if (mimeType.equals("text/plain")) {
            try {
                return blob.getString();
            }
            catch (IOException e) {
                log.warn((Object)("Couldn't convert to fulltext..." + e.getMessage()));
                return "";
            }
        }
        String res = "";
        BlobExtractor extractor = service.getBlobExtractorByName(desc.getBlobExtractorName());
        if (extractor != null) {
            try {
                if (!(blob instanceof StreamingBlob) && !(blob instanceof LazyBlob)) {
                    log.warn((Object)"Blob to be extracted is NOT a StreamingBlob instance... Might be inefficient in case of large binaries...");
                }
                res = extractor.extract(blob, mimeType, desc);
            }
            catch (Throwable t) {
                log.error((Object)"Canot extract blob content using transformer... Cancelling. Fulltext won't be available completly  for this document", t);
            }
        } else {
            log.warn((Object)"No blob extractor found within the full text descriptor field. Please check out your configuration.");
        }
        blob = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResolvedResources computeAggregatedResolvedResourcesFrom(IndexableResources resources, boolean fulltext) throws IndexingException {
        ArrayList<ResolvedData> commonData = new ArrayList<ResolvedData>();
        if (fulltext && !resources.getIndexableResources().isEmpty()) {
            commonData.add(ResolvedResourcesFactory.computeFulltext(resources));
        }
        ACP acp = null;
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        boolean acpComputed = false;
        boolean builtinComputed = false;
        for (IndexableResource resource : resources.getIndexableResources()) {
            IndexableResourceConf conf = resource.getConfiguration();
            if (conf.getType().equals("schema")) {
                ArrayList<ResolvedData> resolvedDatas = new ArrayList<ResolvedData>();
                DocumentIndexableResource docResource = (DocumentIndexableResource)resource;
                for (IndexableResourceDataConf dataConf : conf.getIndexableFields().values()) {
                    String schemaName = conf.getName();
                    String name = dataConf.getIndexingName();
                    Serializable value = null;
                    String computedKey = schemaName + ':' + name;
                    value = resource.getValueFor(computedKey);
                    resolvedDatas.add(new ResolvedDataImpl(dataConf.getIndexingName(), dataConf.getIndexingAnalyzer(), dataConf.getIndexingType(), value, dataConf.isStored(), dataConf.isIndexed(), dataConf.isMultiple(), dataConf.isSortable(), dataConf.getSortOption(), dataConf.getTermVector(), dataConf.isBinary(), dataConf.getProperties()));
                }
                if (!acpComputed) {
                    acp = docResource.getDocMergedACP();
                    acpComputed = true;
                }
                resolvedResources.add(new ResolvedResourceImpl(resources.getId(), resource, resolvedDatas));
                continue;
            }
            String resourceType = conf.getType();
            ResourceTypeDescriptor resourceTypeDesc = ResolvedResourcesFactory.getSearchService().getResourceTypeDescriptorByName(resourceType);
            if (resourceTypeDesc == null) {
                throw new IndexingException("Cannot find associated resource type descriptor for resource type = " + resourceType);
            }
            IndexableResourceFactory factory = resourceTypeDesc.getFactory();
            if (factory == null) {
                throw new IndexingException("Cannot find associated factoryfor resource type = " + resourceType);
            }
            ResolvedResource rr = factory.resolveResourceFor(resource);
            if (!acpComputed) {
                acp = resource.computeAcp();
            }
            if (resourceType.equals("documentBuiltins")) {
                if (builtinComputed) continue;
                commonData.addAll(rr.getIndexableData());
                builtinComputed = true;
                continue;
            }
            if (rr != null) {
                resolvedResources.add(rr);
                continue;
            }
            log.debug((Object)("Resolved resource " + resourceType + " is empty. Ignoring"));
        }
        ResolvedResourcesImpl results = new ResolvedResourcesImpl(resources.getId(), resolvedResources, commonData, acp);
        return results;
    }
}

