/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class QueryModelService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService";
    private static final Log log = LogFactory.getLog(QueryModelService.class);
    private Map<String, QueryModelDescriptor> descriptors;

    public QueryModelDescriptor getQueryModelDescriptor(String descriptorName) {
        return this.descriptors.get(descriptorName);
    }

    public void activate(ComponentContext context) {
        this.descriptors = new HashMap<String, QueryModelDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.descriptors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        QueryModelDescriptor descriptor = (QueryModelDescriptor)contribution;
        if (descriptor.isStateful()) {
            descriptor.initEscaper(contributor.getContext());
        }
        this.descriptors.put(descriptor.getName(), descriptor);
        log.debug((Object)("registered QueryModelDescriptor: " + descriptor.getName()));
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        QueryModelDescriptor descriptor = (QueryModelDescriptor)contribution;
        this.descriptors.remove(descriptor.getName());
        log.debug((Object)("unregistered QueryModelDescriptor: " + descriptor.getName()));
    }
}

