/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.Properties;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.protocol.nxtheme.Handler;
import org.nuxeo.theme.relations.RelationStorage;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.services.ThemeService;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.UidManager;
import org.nuxeo.theme.vocabularies.VocabularyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager {
    private static final String PROTOCOL_HANDLER_PKG = "org.nuxeo.theme.protocol";

    private Manager() {
    }

    private static ThemeService getThemeService() {
        return (ThemeService)((Object)Framework.getRuntime().getComponent(ThemeService.ID));
    }

    private static Map<String, Registrable> getRegistries() {
        return Manager.getThemeService().getRegistries();
    }

    public static Registrable getRegistry(String name) {
        return Manager.getRegistries().get(name);
    }

    public static RelationStorage getRelationStorage() {
        return (RelationStorage)Manager.getRegistry("relations");
    }

    public static UidManager getUidManager() {
        return (UidManager)Manager.getRegistry("uids");
    }

    public static ThemeManager getThemeManager() {
        return (ThemeManager)Manager.getRegistry("themes");
    }

    public static TypeRegistry getTypeRegistry() {
        return (TypeRegistry)Manager.getRegistry("types");
    }

    public static ResourceManager getResourceManager() {
        return (ResourceManager)Manager.getRegistry("resources");
    }

    public static PerspectiveManager getPerspectiveManager() {
        return (PerspectiveManager)Manager.getRegistry("perspectives");
    }

    public static VocabularyManager getVocabularyManager() {
        return (VocabularyManager)Manager.getRegistry("vocabularies");
    }

    public static void initializeProtocols() {
        Properties properties = System.getProperties();
        String handlers = System.getProperty("java.protocol.handler.pkgs");
        if (handlers == null) {
            properties.put("java.protocol.handler.pkgs", PROTOCOL_HANDLER_PKG);
        } else if (!handlers.matches(PROTOCOL_HANDLER_PKG)) {
            properties.put("java.protocol.handler.pkgs", "org.nuxeo.theme.protocol|" + handlers);
        }
        System.setProperties(properties);
        boolean protocolInitialized = true;
        try {
            new URL("nxtheme://test");
        }
        catch (MalformedURLException e) {
            protocolInitialized = false;
        }
        if (!protocolInitialized) {
            try {
                URLStreamHandlerFactoryInstaller.installURLStreamHandlerFactory((URLStreamHandlerFactory)new URLStreamHandlerFactory(){

                    public URLStreamHandler createURLStreamHandler(String protocol) {
                        if ("nxtheme".equals(protocol)) {
                            return new Handler();
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        Manager.initializeProtocols();
    }
}

