/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.relations.DyadicRelation;
import org.nuxeo.theme.relations.Relate;
import org.nuxeo.theme.relations.Relation;
import org.nuxeo.theme.relations.RelationStorage;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementFormatter {
    private ElementFormatter() {
    }

    public static void setFormat(Object object, Format format) {
        Format oldFormat = ElementFormatter.getFormatByType(object, format.getFormatType());
        if (oldFormat != null) {
            ElementFormatter.removeFormat(object, oldFormat);
        }
        Manager.getRelationStorage().add(new DyadicRelation(format.getPredicate(), (Element)object, format));
    }

    public static Format getFormatByType(Object object, FormatType type) {
        Collection<Relation> relations = Manager.getRelationStorage().search(type.getPredicate(), (Element)object, null);
        Iterator<Relation> i = relations.iterator();
        if (i.hasNext()) {
            return (Format)((DyadicRelation)i.next()).getRelate(2);
        }
        return null;
    }

    public static Collection<Format> getFormatsFor(Element element) {
        String[] formatTypeNames;
        ArrayList<Format> formats = new ArrayList<Format>();
        for (String typeName : formatTypeNames = new String[]{"widget", "style", "layout"}) {
            Format format = ElementFormatter.getFormatFor(element, typeName);
            if (format == null) continue;
            formats.add(format);
        }
        return formats;
    }

    public static Format getFormatFor(Element element, String typeName) {
        TypeRegistry typeRegistry;
        FormatType type;
        RelationStorage relationStorage = Manager.getRelationStorage();
        Iterator<Relation> i$ = relationStorage.search((type = (FormatType)(typeRegistry = Manager.getTypeRegistry()).lookup(TypeFamily.FORMAT, typeName)).getPredicate(), element, null).iterator();
        if (i$.hasNext()) {
            Relation relation = i$.next();
            return (Format)relation.getRelate(2);
        }
        return null;
    }

    public static Collection<Element> getElementsFor(Format format) {
        ArrayList<Element> elements = new ArrayList<Element>();
        RelationStorage relationStorage = Manager.getRelationStorage();
        String[] formatTypeNames = new String[]{"widget", "style", "layout"};
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (String typeName : formatTypeNames) {
            FormatType type = (FormatType)typeRegistry.lookup(TypeFamily.FORMAT, typeName);
            for (Relation relation : relationStorage.search(type.getPredicate(), null, format)) {
                elements.add((Element)relation.getRelate(1));
            }
        }
        return elements;
    }

    public static void removeFormat(Object object, Format format) {
        RelationStorage relationStorage = Manager.getRelationStorage();
        for (Relation relation : relationStorage.search(format.getPredicate(), (Relate)object, format)) {
            relationStorage.remove(relation);
        }
    }
}

