/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.formats.styles;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.nuxeo.theme.formats.DefaultFormat;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.styles.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleFormat
extends DefaultFormat
implements Style {
    private final Map<String, Map<String, Properties>> styleProperties = new TreeMap<String, Map<String, Properties>>();
    private final Map<String, String> selectorDescriptions = new HashMap<String, String>();

    @Override
    public Properties getPropertiesFor(String viewName, String path) {
        Map<String, Properties> propertiesMap = this.styleProperties.get(viewName);
        if (propertiesMap != null) {
            return propertiesMap.get(path);
        }
        return null;
    }

    @Override
    public void setPropertiesFor(String viewName, String path, Properties properties) {
        Properties updatedProperties;
        Map<String, Properties> propertiesMap = this.styleProperties.get(viewName);
        if (propertiesMap == null) {
            propertiesMap = new LinkedHashMap<String, Properties>();
        }
        if ((updatedProperties = propertiesMap.get(path)) == null) {
            updatedProperties = new Properties();
        }
        if (properties != null) {
            for (Object key : properties.keySet()) {
                String value = properties.getProperty((String)key);
                if (value.equals("")) {
                    if (!updatedProperties.containsKey(key)) continue;
                    updatedProperties.remove(key);
                    continue;
                }
                updatedProperties.put(key, value);
            }
            propertiesMap.put(path, updatedProperties);
        } else {
            propertiesMap.remove(path);
        }
        if (propertiesMap.isEmpty()) {
            this.styleProperties.remove(viewName);
        } else {
            this.styleProperties.put(viewName, propertiesMap);
        }
    }

    @Override
    public void clearPropertiesFor(String viewName) {
        this.styleProperties.remove(viewName);
    }

    @Override
    public void clearPropertiesFor(String viewName, String path) {
        this.setPropertiesFor(viewName, path, null);
    }

    @Override
    public Set<String> getPathsForView(String viewName) {
        if (this.styleProperties.containsKey(viewName)) {
            return this.styleProperties.get(viewName).keySet();
        }
        return new HashSet<String>();
    }

    @Override
    public Set<String> getSelectorViewNames() {
        return this.styleProperties.keySet();
    }

    @Override
    public String getSelectorDescription(String path, String viewName) {
        if (viewName == null) {
            viewName = "*";
        }
        String key = String.format("%s/%s", path, viewName);
        return this.selectorDescriptions.get(key);
    }

    @Override
    public void setSelectorDescription(String path, String viewName, String description) {
        if (viewName == null) {
            viewName = "*";
        }
        String key = String.format("%s/%s", path, viewName);
        this.selectorDescriptions.put(key, description);
    }

    @Override
    public Properties getAllProperties() {
        Properties properties = new Properties();
        for (Map<String, Properties> map : this.styleProperties.values()) {
            for (Properties s : map.values()) {
                properties.putAll((Map<?, ?>)s);
            }
        }
        return properties;
    }

    @Override
    public void clonePropertiesOf(Format source) {
        super.clonePropertiesOf(source);
        Style sourceStyle = (Style)source;
        for (String viewName : sourceStyle.getSelectorViewNames()) {
            for (String path : sourceStyle.getPathsForView(viewName)) {
                this.setPropertiesFor(viewName, path, sourceStyle.getPropertiesFor(viewName, path));
            }
        }
    }

    @Override
    public boolean isNamed() {
        return this.getName() != null;
    }
}

