/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.negotiation;

import java.util.Iterator;
import java.util.List;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.negotiation.NegotiationException;
import org.nuxeo.theme.negotiation.NegotiationType;
import org.nuxeo.theme.negotiation.Negotiator;
import org.nuxeo.theme.negotiation.Scheme;
import org.nuxeo.theme.types.TypeFamily;

public abstract class AbstractNegotiator
implements Negotiator {
    private static final String SPEC_PREFIX = "nxtheme://theme";
    private final String strategy;
    private final Object context;

    public abstract String getTemplateEngineName();

    protected AbstractNegotiator(String strategy, Object context) {
        this.strategy = strategy;
        this.context = context;
    }

    public final String getSpec() throws NegotiationException {
        return String.format("%s/%s/%s/%s/%s/%s", SPEC_PREFIX, this.negotiate("engine"), this.negotiate("mode"), this.getTemplateEngineName(), this.negotiate("theme"), this.negotiate("perspective"));
    }

    public final synchronized String negotiate(String object) throws NegotiationException {
        if (this.strategy == null) {
            throw new NegotiationException("No negotiation strategy is set.");
        }
        NegotiationType negotiation = (NegotiationType)Manager.getTypeRegistry().lookup(TypeFamily.NEGOTIATION, String.format("%s/%s", this.strategy, object));
        if (negotiation == null) {
            throw new NegotiationException("Could not obtain negotiation for: " + this.strategy + " (strategy) " + object + " (object)");
        }
        List<Scheme> schemes = negotiation.getSchemes();
        String outcome = null;
        if (schemes != null) {
            Scheme scheme;
            Iterator<Scheme> i$ = negotiation.getSchemes().iterator();
            while (i$.hasNext() && (outcome = (scheme = i$.next()).getOutcome(this.context)) == null) {
            }
        }
        if (outcome == null) {
            throw new NegotiationException("No negotiation outcome found for:  " + this.strategy + " (strategy) " + object + " (object)");
        }
        return outcome;
    }
}

