/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.nodes;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.nodes.NodeException;
import org.nuxeo.theme.nodes.NodeTypeFamily;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements Node {
    private Node parentNode;
    private List<Node> childrenNodes = new ArrayList<Node>();

    @Override
    public void clearParent() {
        this.parentNode = null;
    }

    @Override
    public void setParent(Node parent) throws NodeException {
        if (this.equals(parent)) {
            throw new NodeException(String.format("A node cannot be made a parent of itself: %s.", this));
        }
        if (parent != null && parent.isChildOf(this)) {
            throw new NodeException(String.format("Cycle detected while trying to make %s a parent of %s.", parent, this));
        }
        if (this.parentNode != null) {
            List<Node> siblings = this.parentNode.getChildren();
            siblings.remove(this);
            this.parentNode.setChildren(siblings);
        }
        this.parentNode = parent;
    }

    @Override
    public Node getParent() {
        return this.parentNode;
    }

    @Override
    public Node addChild(Node node) throws NodeException {
        if (this.equals(node)) {
            throw new NodeException(String.format("A node cannot be made a child of itself: %s.", this));
        }
        if (this.isChildOf(node)) {
            throw new NodeException(String.format("Cycle detected while trying to add child %s to %s.", node, this));
        }
        this.childrenNodes.add(node);
        node.setParent(this);
        return node;
    }

    @Override
    public void removeChild(Node node) throws NodeException {
        if (!this.childrenNodes.contains(node)) {
            throw new NodeException(String.format("Trying to remove unexisting child %s of %s", node, this));
        }
        this.childrenNodes.remove(node);
        node.setParent(null);
    }

    @Override
    public List<Node> getChildren() {
        return this.childrenNodes;
    }

    @Override
    public void setChildren(List<Node> children) throws NodeException {
        for (Node child : children) {
            if (this.equals(child)) {
                throw new NodeException(String.format("Node %s cannot be made a child of itself", child));
            }
            if (!this.isChildOf(child)) continue;
            throw new NodeException(String.format("Cycle detected while trying to set children of %s.", this));
        }
        this.childrenNodes = children;
    }

    @Override
    public abstract NodeTypeFamily getNodeTypeFamily();

    @Override
    public boolean isLeaf() {
        return this.getNodeTypeFamily() == NodeTypeFamily.LEAF;
    }

    @Override
    public Integer getOrder() {
        Integer order = null;
        if (this.parentNode != null) {
            order = this.parentNode.getChildren().indexOf(this);
        }
        return order;
    }

    @Override
    public void setOrder(Integer order) throws NodeException {
        if (order == null) {
            throw new NodeException(String.format("Cannot set node order to null on %s", this));
        }
        if (this.parentNode == null) {
            throw new NodeException(String.format("Cannot set order on node %s unless it has a parent", this));
        }
        List<Node> siblings = this.parentNode.getChildren();
        siblings.remove(this);
        if (order < 0 || order > 0 && order > siblings.size()) {
            throw new NodeException(String.format("Incorrect node order value (%s) for %s", order, this));
        }
        siblings.add(order, this);
        this.parentNode.setChildren(siblings);
    }

    @Override
    public void moveTo(Node container, Integer order) throws NodeException {
        this.setParent(container);
        this.setOrder(order);
    }

    @Override
    public void insertAfter(Node node) throws NodeException {
        node.getParent().addChild(this);
        this.moveTo(node.getParent(), node.getOrder() + 1);
    }

    @Override
    public boolean hasSiblings() {
        if (this.parentNode == null) {
            return false;
        }
        return this.parentNode.getChildren().size() > 1;
    }

    @Override
    public Node getNextNode() {
        List<Node> siblings;
        int order = this.getOrder();
        if (order + 1 >= (siblings = this.parentNode.getChildren()).size()) {
            return null;
        }
        return siblings.get(order + 1);
    }

    @Override
    public Node getPreviousNode() {
        int order = this.getOrder();
        if (order == 0) {
            return null;
        }
        List<Node> siblings = this.parentNode.getChildren();
        return siblings.get(order - 1);
    }

    @Override
    public boolean hasChildren() {
        return !this.childrenNodes.isEmpty();
    }

    @Override
    public boolean isChildOf(Node node) {
        boolean res = false;
        for (Node parent = this.parentNode; parent != null; parent = parent.getParent()) {
            if (parent != node) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public void removeDescendants() throws NodeException {
        for (Node child : this.childrenNodes) {
            child.removeDescendants();
            child.clearParent();
        }
        this.childrenNodes.clear();
    }

    @Override
    public List<Node> getDescendants() {
        ArrayList<Node> descendants = new ArrayList<Node>();
        this.collectDescendants(descendants);
        return descendants;
    }

    @Override
    public void collectDescendants(List<Node> nodes) {
        for (Node child : this.childrenNodes) {
            nodes.add(child);
            child.collectDescendants(nodes);
        }
    }
}

