/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.properties;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.themes.ThemeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldIO {
    private static final Log log = LogFactory.getLog(FieldIO.class);

    public static FieldInfo getFieldInfo(Class<?> c, String name) {
        try {
            return c.getField(name).getAnnotation(FieldInfo.class);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static void updateFieldsFromProperties(Object object, Properties properties) throws ThemeIOException {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            Field field;
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            Class<?> c = object.getClass();
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, name);
            if (fieldInfo == null) continue;
            try {
                field = c.getField(name);
            }
            catch (SecurityException e) {
                throw new ThemeIOException(e);
            }
            catch (NoSuchFieldException e) {
                log.warn((Object)("Failed to set field '" + name + "' on " + c.getCanonicalName()));
                continue;
            }
            Class<?> fieldType = field.getType();
            Type fieldGenericType = field.getGenericType();
            if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                try {
                    field.set(object, Boolean.parseBoolean(value));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldType.equals(String.class)) {
                try {
                    field.set(object, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                try {
                    if ("".equals(value)) {
                        field.set(object, null);
                        continue;
                    }
                    field.set(object, Integer.valueOf(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Failed to parse integer value: '" + value + "'"));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldGenericType instanceof ParameterizedType) {
                if (!fieldType.equals(ArrayList.class) && !fieldType.equals(List.class) && !fieldType.equals(Collection.class)) continue;
                Type[] actualTypes = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
                if (actualTypes.length > 1) {
                    log.warn((Object)"Only one-dimension arrays are supported.");
                    continue;
                }
                if (!actualTypes[0].equals(String.class)) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(value.split(",")));
                try {
                    field.set(object, list);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            log.warn((Object)("Field type '" + name + "' of " + c.getCanonicalName() + " is not supported: " + fieldType.getCanonicalName()));
        }
    }

    public static Properties dumpFieldsToProperties(Object object) throws ThemeIOException {
        Properties properties = new Properties();
        Class<?> c = object.getClass();
        for (Field field : c.getDeclaredFields()) {
            String value;
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, fieldName);
            if (fieldInfo == null) continue;
            String property = "";
            try {
                Object v = field.get(object);
                value = v == null ? "" : v.toString();
            }
            catch (IllegalAccessException e) {
                throw new ThemeIOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ThemeIOException(e);
            }
            if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                property = Boolean.parseBoolean(value.toString()) ? "true" : "false";
            } else if (fieldType.equals(String.class)) {
                property = value;
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                property = value;
            } else {
                log.warn((Object)("Field type '" + fieldName + "' of " + c.getCanonicalName() + " is not supported: " + fieldType.getCanonicalName()));
                continue;
            }
            properties.setProperty(fieldName, property);
        }
        return properties;
    }
}

