/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.relations.Predicate;
import org.nuxeo.theme.relations.Relate;
import org.nuxeo.theme.relations.Relation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelationStorage
implements Registrable {
    private static final Map<Long, Relation> relationsMap = new HashMap<Long, Relation>();
    private static final Map<List<String>, List<Long>> relatesMap = new HashMap<List<String>, List<Long>>();
    private static final String[][] WILDCARDS_MONADIC = new String[][]{{""}};
    private static final String[][] WILDCARDS_DYADIC = new String[][]{{"", ""}, {"*", ""}, {"", "*"}};
    private static final String[][] WILDCARDS_TRIADIC = new String[][]{{"", "", ""}, {"*", "", ""}, {"", "*", ""}, {"", "", "*"}, {"*", "*", ""}, {"", "*", "*"}, {"*", "", "*"}};

    public synchronized void add(Relation relation) {
        Long key = this.findFreeKey();
        relationsMap.put(key, relation);
        this.index(key, relation);
    }

    public synchronized void remove(Relation relation) {
        List<String> indexString = this.computeIndexString(relation.getRelates());
        for (Long id : relatesMap.get(indexString)) {
            relationsMap.remove(id);
        }
        relatesMap.remove(indexString);
    }

    public Collection<Relation> search(Predicate predicate, List<Relate> relates) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        List<String> indexString = this.computeIndexString(relates);
        if (!relatesMap.containsKey(indexString)) {
            return relations;
        }
        for (Long id : relatesMap.get(indexString)) {
            Relation relation = relationsMap.get(id);
            if (relation == null || !relation.hasPredicate(predicate)) continue;
            relations.add(relationsMap.get(id));
        }
        return relations;
    }

    public Collection<Relation> search(Predicate predicate, Relate first) {
        ArrayList<Relate> relates = new ArrayList<Relate>();
        relates.add(first);
        return this.search(predicate, relates);
    }

    public Collection<Relation> search(Predicate predicate, Relate first, Relate second) {
        ArrayList<Relate> relates = new ArrayList<Relate>();
        relates.add(first);
        relates.add(second);
        return this.search(predicate, relates);
    }

    public Collection<Relation> search(Predicate predicate, Relate first, Relate second, Relate third) {
        ArrayList<Relate> relates = new ArrayList<Relate>();
        relates.add(first);
        relates.add(second);
        relates.add(third);
        return this.search(predicate, relates);
    }

    public Collection<Relation> list() {
        return relationsMap.values();
    }

    @Override
    public synchronized void clear() {
        relationsMap.clear();
        relatesMap.clear();
    }

    private synchronized Long findFreeKey() {
        Long key;
        Random generator = new Random();
        while (relationsMap.containsKey(key = Long.valueOf(generator.nextLong()))) {
        }
        return key;
    }

    private synchronized void index(Long id, Relation relation) {
        List<Relate> relates = relation.getRelates();
        String[][] wildcards = null;
        Integer arity = relates.size();
        if (arity == 1) {
            wildcards = WILDCARDS_MONADIC;
        } else if (arity == 2) {
            wildcards = WILDCARDS_DYADIC;
        } else if (arity == 3) {
            wildcards = WILDCARDS_TRIADIC;
        }
        assert (wildcards != null);
        for (String[] wildcard : wildcards) {
            ArrayList<String> indexString = new ArrayList<String>();
            Integer j = 0;
            while (j < arity) {
                if (wildcard[j].equals("*")) {
                    indexString.add("*");
                } else {
                    indexString.add(relates.get(j).hash());
                }
                Integer n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
            List<Object> ids = relatesMap.containsKey(indexString) ? relatesMap.get(indexString) : new ArrayList();
            ids.add(id);
            relatesMap.put(indexString, ids);
        }
    }

    private List<String> computeIndexString(List<Relate> relates) {
        ArrayList<String> indexString = new ArrayList<String>();
        for (Relate relate : relates) {
            if (relate == null || relate.hash() == null) {
                indexString.add("*");
                continue;
            }
            indexString.add(relate.hash());
        }
        return indexString;
    }
}

