/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.rendering;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.rendering.Filter;
import org.nuxeo.theme.rendering.FilterType;
import org.nuxeo.theme.rendering.FilterTypeFamily;
import org.nuxeo.theme.rendering.StandaloneFilter;
import org.nuxeo.theme.rendering.StandaloneFilterFactory;

@XObject(value="standalone-filter")
public final class StandaloneFilterType
extends FilterType {
    @XNode(value="@name")
    public String name;
    @XNode(value="engine")
    public String engine = "*";
    @XNode(value="@template-engine")
    public String templateEngine = "*";
    @XNode(value="mode")
    public String mode = "*";
    @XNode(value="class")
    public String className;
    private final Map<String, Filter> filters = new HashMap<String, Filter>();

    public Filter getFilter() {
        String typeName = this.getTypeName();
        if (this.filters.containsKey(typeName)) {
            return this.filters.get(typeName);
        }
        StandaloneFilter filter = StandaloneFilterFactory.create(typeName);
        this.filters.put(typeName, filter);
        return filter;
    }

    public FilterTypeFamily getFilterTypeFamily() {
        return FilterTypeFamily.STANDALONE;
    }

    public String getTypeName() {
        return String.format("%s/%s/%s/%s", this.engine, this.templateEngine, this.mode, this.name);
    }

    public String getClassName() {
        return this.className;
    }
}

