/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.base;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.AbstractWebContext;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;

@Path(value="/")
@Produces(value={"text/html; charset=UTF-8"})
@WebObject(type="base")
public class Main
extends ModuleRoot {
    protected final ModuleManager mgr;
    protected Module module;

    public Main() {
        this.ctx = WebEngine.getActiveContext();
        this.path = this.ctx.getBasePath();
        this.mgr = this.ctx.getEngine().getModuleManager();
    }

    protected void init() {
        ModuleConfiguration mc = this.mgr.getRootModule();
        if (mc == null) {
            throw new WebResourceNotFoundException("Root module not registered");
        }
        this.module = mc.get();
        ((AbstractWebContext)this.ctx).setModule(this.module);
        this.type = (ResourceTypeImpl)((ModuleImpl)this.module).getRootType();
        this.setRoot(true);
        this.ctx.push((Resource)this);
    }

    @GET
    public Object doGet() {
        this.init();
        return this.getView("index");
    }

    @GET
    @Path(value="help")
    public Object getHelp() {
        this.init();
        return this.getTemplate("help/help.ftl");
    }

    @GET
    @Path(value="about")
    public Object getAbout() {
        this.init();
        return this.getTemplate("help/about.ftl");
    }

    @Path(value="{path}")
    public Object dispatch(@PathParam(value="path") String path) {
        ModuleConfiguration md = this.mgr.getModuleByPath(path);
        if (md != null) {
            return md.get().getRootObject(this.ctx);
        }
        throw new WebResourceNotFoundException("No resource found at " + path);
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error/error_401.ftl")).build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).build();
        }
        return super.handleError(e);
    }
}

