/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.virtualnavigation.service.NavTreeService;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="multiNavTreeManager")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class MultiNavTreeManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MultiNavTreeManager.class);
    public static final String STD_NAV_TREE = "CONTENT_TREE";
    public static final String STD_NAV_TREE_LABEL = "label.content.tree";
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(required=false, create=true)
    protected DirectoryTreeManager directoryTreeManager;
    private static List<NavTreeDescriptor> availableNavigationTrees;
    private static String thePath;
    private String selectedNavigationTree;

    public List<NavTreeDescriptor> getAvailableNavigationTrees() {
        if (availableNavigationTrees == null) {
            availableNavigationTrees = new ArrayList<NavTreeDescriptor>();
            availableNavigationTrees.add(new NavTreeDescriptor(STD_NAV_TREE, STD_NAV_TREE_LABEL));
            NavTreeService navTreeService = (NavTreeService)((Object)Framework.getLocalService(NavTreeService.class));
            availableNavigationTrees.addAll(navTreeService.getTreeDescriptors());
        }
        return availableNavigationTrees;
    }

    @Factory(value="selectedNavigationTree", scope=ScopeType.EVENT)
    public String getSelectedNavigationTree() {
        if (this.selectedNavigationTree == null) {
            this.setSelectedNavigationTree(STD_NAV_TREE);
        }
        return this.selectedNavigationTree;
    }

    @Factory(value="selectedNavigationTreeDescriptor", scope=ScopeType.EVENT)
    public NavTreeDescriptor getSelectedNavigationTreeDescriptor() {
        String navTreeName = this.getSelectedNavigationTree();
        for (NavTreeDescriptor desc : this.getAvailableNavigationTrees()) {
            if (!desc.getTreeId().equals(navTreeName)) continue;
            return desc;
        }
        return null;
    }

    public void setSelectedNavigationTree(String selectedNavigationTree) {
        this.directoryTreeManager.setSelectedTreeName(selectedNavigationTree);
        this.selectedNavigationTree = selectedNavigationTree;
        Events.instance().raiseEvent("folderishDocumentSelectionChanged", new Object[]{new DocumentModelImpl("Folder")});
    }

    @Observer(value={"PATH_PROCESSED"}, create=false)
    @BypassInterceptors
    public void setThePath(String myPath) {
        thePath = myPath;
    }

    public String getVirtualNavPath() {
        String[] partOfPath = thePath.split("/");
        String finalPath = "";
        for (String aPart : partOfPath) {
            finalPath = finalPath + " > " + (String)this.resourcesAccessor.getMessages().get(aPart);
        }
        return finalPath;
    }

    static {
        thePath = "";
    }
}

