/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavTreeService
extends DefaultComponent {
    public static String NAVTREE_EP = "navigationTree";
    protected List<NavTreeDescriptor> descriptors;
    protected boolean directoryTreesFetched;

    public List<NavTreeDescriptor> getTreeDescriptors() {
        this.maybeFetchDirectoryTrees();
        return this.descriptors;
    }

    protected synchronized void maybeFetchDirectoryTrees() {
        if (this.directoryTreesFetched) {
            return;
        }
        DirectoryTreeService directoryTreeService = (DirectoryTreeService)Framework.getRuntime().getComponent(DirectoryTreeService.NAME);
        if (directoryTreeService == null) {
            return;
        }
        List treeNames = directoryTreeService.getDirectoryTrees();
        for (String dTreeName : treeNames) {
            this.descriptors.add(new NavTreeDescriptor(dTreeName, "label." + dTreeName, true));
        }
        this.directoryTreesFetched = true;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (NAVTREE_EP.equals(extensionPoint)) {
            this.descriptors.add((NavTreeDescriptor)contribution);
        }
    }

    public void activate(ComponentContext context) throws Exception {
        this.directoryTreesFetched = false;
        this.descriptors = new ArrayList<NavTreeDescriptor>();
    }
}

