/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OSGiBundleContext
implements BundleContext {
    final BundleImpl bundle;

    public OSGiBundleContext(BundleImpl bundle) {
        this.bundle = bundle;
    }

    public OSGiAdapter getOSGiAdapter() {
        return this.bundle.osgi;
    }

    public void addBundleListener(BundleListener listener) {
        this.bundle.osgi.addBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.bundle.osgi.addFrameworkListener(listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.bundle.osgi.addServiceListener(listener);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.bundle.osgi.addServiceListener(listener, filter);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        throw new UnsupportedOperationException("BundleContext.createFilter() was not yet implemented");
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle getBundle(long id) {
        return this.bundle.osgi.registry.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.bundle.osgi.registry.getInstalledBundles();
    }

    public File getDataFile(String filename) {
        return new File(this.bundle.osgi.getWorkingDir(), filename);
    }

    public String getProperty(String key) {
        return this.bundle.osgi.getProperty(key);
    }

    public Object getService(ServiceReference reference) {
        return null;
    }

    public ServiceReference getServiceReference(String clazz) {
        return null;
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return null;
    }

    public Bundle installBundle(String location) throws BundleException {
        File file = new File(location);
        try {
            BundleFile bf = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            BundleImpl b = new BundleImpl(this.bundle.osgi, bf, this.bundle.loader);
            if (b.getSymbolicName() != null) {
                this.bundle.osgi.install(b);
            }
            return b;
        }
        catch (IOException e) {
            throw new BundleException("Failed to install bundle at " + location, (Throwable)e);
        }
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return null;
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return null;
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return null;
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundle.osgi.removeBundleListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.bundle.osgi.removeFrameworkListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.bundle.osgi.removeServiceListener(listener);
    }

    public boolean ungetService(ServiceReference reference) {
        return false;
    }
}

