/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;

@XObject(value="directory")
public class MultiDirectoryDescriptor
implements Cloneable {
    @XNode(value="@name")
    public String name;
    @XNode(value="schema")
    protected String schemaName;
    @XNode(value="idField")
    protected String idField;
    @XNode(value="passwordField")
    protected String passwordField;
    @XNode(value="readOnly")
    public Boolean readOnly;
    @XNode(value="querySizeLimit")
    public Integer querySizeLimit;
    @XNode(value="@remove")
    public boolean remove = false;
    @XNodeList(value="source", type=SourceDescriptor[].class, componentType=SourceDescriptor.class)
    protected SourceDescriptor[] sources;

    public void merge(MultiDirectoryDescriptor other) {
        if (other.schemaName != null) {
            this.schemaName = other.schemaName;
        }
        if (other.idField != null) {
            this.idField = other.idField;
        }
        if (other.passwordField != null) {
            this.passwordField = other.passwordField;
        }
        if (other.readOnly != null) {
            this.readOnly = other.readOnly;
        }
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.sources != null) {
            if (this.sources == null) {
                this.sources = other.sources;
            } else {
                SourceDescriptor[] s = new SourceDescriptor[this.sources.length + other.sources.length];
                System.arraycopy(this.sources, 0, s, 0, this.sources.length);
                System.arraycopy(other.sources, 0, s, s.length, other.sources.length);
                this.sources = s;
            }
        }
    }
}

