/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="openUrl")
public class OpenUrlDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="grantPattern")
    protected String grantPattern;
    protected Pattern compiledGrantPattern;
    @XNode(value="denyPattern")
    protected String denyPattern;
    protected Pattern compiledDenyPattern;
    @XNode(value="method")
    protected String method;

    public String getName() {
        return this.name;
    }

    public String getGrantPattern() {
        return this.grantPattern;
    }

    public Pattern getCompiledGrantPattern() {
        if (this.compiledGrantPattern == null && this.grantPattern != null && this.grantPattern.length() > 0) {
            this.compiledGrantPattern = Pattern.compile(this.grantPattern);
        }
        return this.compiledGrantPattern;
    }

    public Pattern getCompiledDenyPattern() {
        if (this.compiledDenyPattern == null && this.denyPattern != null && this.denyPattern.length() > 0) {
            this.compiledDenyPattern = Pattern.compile(this.denyPattern);
        }
        return this.compiledDenyPattern;
    }

    public String getDenyPattern() {
        return this.denyPattern;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean allowByPassAuth(HttpServletRequest httpRequest) {
        Matcher grantMatcher;
        Matcher denyMatcher;
        String uri = httpRequest.getRequestURI();
        String method = httpRequest.getMethod();
        if (this.getMethod() != null && !this.getMethod().equals(method)) {
            return false;
        }
        Pattern deny = this.getCompiledDenyPattern();
        if (deny != null && (denyMatcher = deny.matcher(uri)).matches()) {
            return false;
        }
        Pattern grant = this.getCompiledGrantPattern();
        return grant != null && (grantMatcher = grant.matcher(uri)).matches();
    }
}

