/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallbackHandler;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPropagator;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationSessionManager;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoCallbackHandlerFactory;
import org.nuxeo.ecm.platform.ui.web.auth.plugins.DefaultSessionManager;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationChainDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationPluginDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationPropagatorDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.CallbackHandlerFactoryDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.OpenUrlDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.SessionManagerDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.SpecificAuthChainDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.StartURLPatternDescriptor;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluggableAuthenticationService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService";
    public static final String EP_AUTHENTICATOR = "authenticators";
    public static final String EP_SESSIONMANAGER = "sessionManager";
    public static final String EP_CHAIN = "chain";
    public static final String EP_SPECIFIC_CHAINS = "specificChains";
    public static final String EP_PROPAGATOR = "propagator";
    public static final String EP_CBFACTORY = "JbossCallbackfactory";
    public static final String EP_STARTURL = "startURL";
    public static final String EP_OPENURL = "openUrl";
    private static final Log log = LogFactory.getLog(PluggableAuthenticationService.class);
    private Map<String, AuthenticationPluginDescriptor> authenticatorsDescriptors;
    private Map<String, NuxeoAuthenticationPlugin> authenticators;
    private Map<String, NuxeoAuthenticationSessionManager> sessionManagers;
    private NuxeoAuthenticationSessionManager defaultSessionManager;
    private NuxeoAuthenticationPropagator propagator;
    private NuxeoCallbackHandlerFactory cbhFactory;
    private List<String> authChain;
    private Map<String, SpecificAuthChainDescriptor> specificAuthChains = new HashMap<String, SpecificAuthChainDescriptor>();
    private List<OpenUrlDescriptor> openUrls = new ArrayList<OpenUrlDescriptor>();
    private final List<String> startupURLs = new ArrayList<String>();

    public void activate(ComponentContext context) {
        this.authenticatorsDescriptors = new HashMap<String, AuthenticationPluginDescriptor>();
        this.authChain = new ArrayList<String>();
        this.authenticators = new HashMap<String, NuxeoAuthenticationPlugin>();
        this.sessionManagers = new HashMap<String, NuxeoAuthenticationSessionManager>();
        this.defaultSessionManager = new DefaultSessionManager();
    }

    public void deactivate(ComponentContext context) {
        this.authenticatorsDescriptors = null;
        this.authenticators = null;
        this.authChain = null;
        this.sessionManagers = null;
        this.defaultSessionManager = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EP_AUTHENTICATOR)) {
            AuthenticationPluginDescriptor descriptor = (AuthenticationPluginDescriptor)contribution;
            if (this.authenticatorsDescriptors.containsKey(descriptor.getName())) {
                this.mergeDescriptors(descriptor);
                log.debug((Object)("merged AuthenticationPluginDescriptor: " + descriptor.getName()));
            } else {
                this.authenticatorsDescriptors.put(descriptor.getName(), descriptor);
                log.debug((Object)("registered AuthenticationPluginDescriptor: " + descriptor.getName()));
            }
            AuthenticationPluginDescriptor actualDescriptor = this.authenticatorsDescriptors.get(descriptor.getName());
            try {
                NuxeoAuthenticationPlugin authPlugin = actualDescriptor.getClassName().newInstance();
                authPlugin.initPlugin(actualDescriptor.getParameters());
                this.authenticators.put(actualDescriptor.getName(), authPlugin);
            }
            catch (InstantiationException e) {
                log.error((Object)("Unable to create AuthPlugin for : " + actualDescriptor.getName() + "Error : " + e.getMessage()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Unable to create AuthPlugin for : " + actualDescriptor.getName() + "Error : " + e.getMessage()), (Throwable)e);
            }
        } else if (extensionPoint.equals(EP_CHAIN)) {
            AuthenticationChainDescriptor chainContrib = (AuthenticationChainDescriptor)contribution;
            this.authChain.clear();
            this.authChain.addAll(chainContrib.getPluginsNames());
        } else if (extensionPoint.equals(EP_OPENURL)) {
            OpenUrlDescriptor openUrlContrib = (OpenUrlDescriptor)contribution;
            this.openUrls.add(openUrlContrib);
        } else if (extensionPoint.equals(EP_STARTURL)) {
            StartURLPatternDescriptor startupURLContrib = (StartURLPatternDescriptor)contribution;
            this.startupURLs.addAll(startupURLContrib.getStartURLPatterns());
        } else if (extensionPoint.equals(EP_PROPAGATOR)) {
            AuthenticationPropagatorDescriptor propagationContrib = (AuthenticationPropagatorDescriptor)contribution;
            try {
                this.propagator = propagationContrib.getClassName().newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"Unable to create propagator", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Unable to create propagator", (Throwable)e);
            }
        } else if (extensionPoint.equals(EP_CBFACTORY)) {
            CallbackHandlerFactoryDescriptor cbhfContrib = (CallbackHandlerFactoryDescriptor)contribution;
            try {
                this.cbhFactory = cbhfContrib.getClassName().newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"Unable to create callback handler factory", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Unable to create callback handler factory", (Throwable)e);
            }
        } else if (extensionPoint.equals(EP_SESSIONMANAGER)) {
            SessionManagerDescriptor smContrib = (SessionManagerDescriptor)contribution;
            if (smContrib.enabled) {
                try {
                    NuxeoAuthenticationSessionManager sm = smContrib.getClassName().newInstance();
                    this.sessionManagers.put(smContrib.getName(), sm);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to create session manager", (Throwable)e);
                }
            } else {
                this.sessionManagers.remove(smContrib.getName());
            }
        } else if (extensionPoint.equals(EP_SPECIFIC_CHAINS)) {
            SpecificAuthChainDescriptor desc = (SpecificAuthChainDescriptor)contribution;
            this.specificAuthChains.put(desc.name, desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EP_AUTHENTICATOR)) {
            AuthenticationPluginDescriptor descriptor = (AuthenticationPluginDescriptor)contribution;
            this.authenticatorsDescriptors.remove(descriptor.getName());
            log.debug((Object)("unregistered AuthenticationPlugin: " + descriptor.getName()));
        }
    }

    private void mergeDescriptors(AuthenticationPluginDescriptor newContrib) {
        AuthenticationPluginDescriptor oldDescriptor = this.authenticatorsDescriptors.get(newContrib.getName());
        oldDescriptor.setEnabled(newContrib.getEnabled());
        Map<String, String> oldParameters = oldDescriptor.getParameters();
        oldParameters.putAll(newContrib.getParameters());
        oldDescriptor.setParameters(oldParameters);
        if (newContrib.getLoginModulePlugin() != null && newContrib.getLoginModulePlugin().length() > 0) {
            oldDescriptor.setLoginModulePlugin(newContrib.getLoginModulePlugin());
        }
        oldDescriptor.setStateful(newContrib.getStateful());
        if (newContrib.getClassName() != null) {
            oldDescriptor.setClassName(newContrib.getClassName());
        }
        oldDescriptor.setNeedStartingURLSaving(newContrib.getNeedStartingURLSaving());
    }

    public List<String> getStartURLPatterns() {
        return this.startupURLs;
    }

    public List<String> getAuthChain() {
        return this.authChain;
    }

    public List<String> getAuthChain(HttpServletRequest request) {
        if (this.specificAuthChains == null || this.specificAuthChains.size() == 0) {
            return this.getAuthChain();
        }
        String specificAuthChainName = this.getSpecificAuthChainName(request);
        SpecificAuthChainDescriptor desc = this.specificAuthChains.get(specificAuthChainName);
        if (desc != null) {
            return desc.computeResultingChain(this.getAuthChain());
        }
        return this.getAuthChain();
    }

    public String getSpecificAuthChainName(HttpServletRequest request) {
        for (String specificAuthChainName : this.specificAuthChains.keySet()) {
            SpecificAuthChainDescriptor desc = this.specificAuthChains.get(specificAuthChainName);
            List<Pattern> urlPatterns = desc.getUrlPatterns();
            if (urlPatterns.size() > 0) {
                String requestUrl = request.getRequestURI();
                for (Pattern pattern : urlPatterns) {
                    Matcher m = pattern.matcher(requestUrl);
                    if (!m.matches()) continue;
                    return specificAuthChainName;
                }
            }
            Map<String, Pattern> headerPattern = desc.getHeaderPatterns();
            for (String headerName : headerPattern.keySet()) {
                Matcher m;
                String headerValue = request.getHeader(headerName);
                if (headerValue == null || !(m = headerPattern.get(headerName).matcher(headerValue)).matches()) continue;
                return specificAuthChainName;
            }
        }
        return null;
    }

    public UserIdentificationInfoCallbackHandler getCallbackHandler(UserIdentificationInfo userIdent) {
        if (this.cbhFactory == null) {
            return new UserIdentificationInfoCallbackHandler(userIdent);
        }
        return this.cbhFactory.createCallbackHandler(userIdent);
    }

    public void propagateUserIdentificationInformation(CachableUserIdentificationInfo cachableUserIdent) {
        if (this.propagator != null) {
            this.propagator.propagateUserIdentificationInformation(cachableUserIdent);
        }
    }

    public List<NuxeoAuthenticationPlugin> getPluginChain() {
        ArrayList<NuxeoAuthenticationPlugin> result = new ArrayList<NuxeoAuthenticationPlugin>();
        for (String pluginName : this.authChain) {
            if (!this.authenticatorsDescriptors.containsKey(pluginName) || !this.authenticatorsDescriptors.get(pluginName).getEnabled() || !this.authenticators.containsKey(pluginName)) continue;
            result.add(this.authenticators.get(pluginName));
        }
        return result;
    }

    public NuxeoAuthenticationPlugin getPlugin(String pluginName) {
        if (this.authenticatorsDescriptors.containsKey(pluginName) && this.authenticatorsDescriptors.get(pluginName).getEnabled() && this.authenticators.containsKey(pluginName)) {
            return this.authenticators.get(pluginName);
        }
        return null;
    }

    public AuthenticationPluginDescriptor getDescriptor(String pluginName) {
        if (this.authenticatorsDescriptors.containsKey(pluginName)) {
            return this.authenticatorsDescriptors.get(pluginName);
        }
        log.error((Object)("Plugin " + pluginName + " not registered or not created"));
        return null;
    }

    public void invalidateSession(ServletRequest request) {
        HttpServletRequest httpRequest;
        HttpSession session;
        if (!this.sessionManagers.isEmpty()) {
            for (String smName : this.sessionManagers.keySet()) {
                NuxeoAuthenticationSessionManager sm = this.sessionManagers.get(smName);
                sm.onBeforeSessionInvalidate(request);
            }
        }
        if ((session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
            session.invalidate();
        }
    }

    public HttpSession reinitSession(HttpServletRequest httpRequest) {
        if (!this.sessionManagers.isEmpty()) {
            for (String smName : this.sessionManagers.keySet()) {
                NuxeoAuthenticationSessionManager sm = this.sessionManagers.get(smName);
                sm.onBeforeSessionReinit((ServletRequest)httpRequest);
            }
        }
        HttpSession session = httpRequest.getSession(true);
        if (!this.sessionManagers.isEmpty()) {
            for (String smName : this.sessionManagers.keySet()) {
                NuxeoAuthenticationSessionManager sm = this.sessionManagers.get(smName);
                sm.onAfterSessionReinit((ServletRequest)httpRequest);
            }
        }
        return session;
    }

    public boolean canBypassRequest(ServletRequest request) {
        if (!this.sessionManagers.isEmpty()) {
            for (String smName : this.sessionManagers.keySet()) {
                NuxeoAuthenticationSessionManager sm = this.sessionManagers.get(smName);
                if (!sm.canBypassRequest(request)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needResetLogin(ServletRequest request) {
        if (!this.sessionManagers.isEmpty()) {
            for (NuxeoAuthenticationSessionManager sm : this.sessionManagers.values()) {
                if (!sm.needResetLogin(request)) continue;
                return true;
            }
        }
        return false;
    }

    public String getBaseURL(ServletRequest request) {
        return VirtualHostHelper.getBaseURL(request);
    }

    public void onAuthenticatedSessionCreated(ServletRequest request, HttpSession session, CachableUserIdentificationInfo cachebleUserInfo) {
        if (!this.sessionManagers.isEmpty()) {
            for (String smName : this.sessionManagers.keySet()) {
                NuxeoAuthenticationSessionManager sm = this.sessionManagers.get(smName);
                sm.onAuthenticatedSessionCreated(request, session, cachebleUserInfo);
            }
        }
    }

    public List<OpenUrlDescriptor> getOpenUrls() {
        return this.openUrls;
    }
}

