/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling.service;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandlerParameters;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ErrorHandlersDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ExceptionHandlerDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ListenerDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.RequestDumpDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.ExceptionHandlingService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.RequestDumper;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ExceptionHandlingComponent
extends DefaultComponent
implements ExceptionHandlingService {
    protected NuxeoExceptionHandler exceptionHandler;
    protected final NuxeoExceptionHandlerParameters exceptionHandlerParameters = new NuxeoExceptionHandlerParameters();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        ExtensionPoint ep = Enum.valueOf(ExtensionPoint.class, extensionPoint);
        switch (ep) {
            case exceptionhandler: {
                ExceptionHandlerDescriptor ehd = (ExceptionHandlerDescriptor)contribution;
                this.exceptionHandler = ehd.getKlass().newInstance();
                this.exceptionHandler.setParameters(this.exceptionHandlerParameters);
                break;
            }
            case errorhandlers: {
                ErrorHandlersDescriptor md = (ErrorHandlersDescriptor)contribution;
                this.exceptionHandlerParameters.setBundleName(md.getBundle());
                this.exceptionHandlerParameters.setHandlers(md.getMessages());
                this.exceptionHandlerParameters.setLoggerName(md.getLoggerName());
                this.exceptionHandlerParameters.setDefaultErrorPage(md.getDefaultPage());
                break;
            }
            case requestdump: {
                RequestDumpDescriptor rdd = (RequestDumpDescriptor)contribution;
                RequestDumper dumper = rdd.getKlass().newInstance();
                List<String> attributes = rdd.getAttributes();
                dumper.setNotListedAttributes(attributes);
                this.exceptionHandlerParameters.setRequestDumper(dumper);
                break;
            }
            case listener: {
                ListenerDescriptor ld = (ListenerDescriptor)contribution;
                this.exceptionHandlerParameters.setListener(ld.getKlass().newInstance());
                break;
            }
            default: {
                throw new RuntimeException("error in exception handling configuration");
            }
        }
    }

    public void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        this.exceptionHandler.handleException(request, response, t);
    }

    public NuxeoExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtensionPoint {
        exceptionhandler,
        errorhandlers,
        requestdump,
        listener;

    }
}

