/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.vh;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualHostHelper {
    private static final Log log = LogFactory.getLog(VirtualHostHelper.class);
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String VH_HEADER = "nuxeo-virtual-host";

    private VirtualHostHelper() {
    }

    private static HttpServletRequest getHttpServletRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    public static String getWebAppName(ServletRequest request) {
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        if (httpRequest == null) {
            return "nuxeo";
        }
        return httpRequest.getContextPath().replace("/", "");
    }

    public static String getServerURL(ServletRequest request) {
        return VirtualHostHelper.getServerURL(request, false);
    }

    private static String getServerUrl(String scheme, String serverName, int serverPort) {
        StringBuilder sbaseURL = new StringBuilder();
        sbaseURL.append(scheme);
        sbaseURL.append("://");
        sbaseURL.append(serverName);
        if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
            sbaseURL.append(':');
            sbaseURL.append(serverPort);
        }
        sbaseURL.append('/');
        return sbaseURL.toString();
    }

    public static String getServerURL(ServletRequest request, boolean local) {
        String baseURL = null;
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        if (httpRequest != null) {
            String nuxeoVH = httpRequest.getHeader(VH_HEADER);
            if (!local && nuxeoVH != null && nuxeoVH.contains("http")) {
                baseURL = nuxeoVH;
            } else {
                String forwardedHost;
                String serverName = httpRequest.getServerName();
                int serverPort = httpRequest.getServerPort();
                if (!local && (forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST)) != null) {
                    if (forwardedHost.contains(":")) {
                        serverName = forwardedHost.split(":")[0];
                        serverPort = Integer.valueOf(forwardedHost.split(":")[1]);
                    } else {
                        serverName = forwardedHost;
                        serverPort = 80;
                    }
                }
                String scheme = httpRequest.getScheme();
                baseURL = VirtualHostHelper.getServerUrl(scheme, serverName, serverPort);
            }
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }

    public static String getBaseURL(ServletRequest request) {
        String baseURL = null;
        String serverUrl = VirtualHostHelper.getServerURL(request, false);
        if (serverUrl != null) {
            baseURL = serverUrl + VirtualHostHelper.getWebAppName(request) + '/';
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }
}

