/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import java.util.Date;
import java.util.List;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.wss.backend.TranslationHelper;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.dws.AbstractTask;
import org.nuxeo.wss.spi.dws.Task;

public class NuxeoTask
extends AbstractTask
implements Task {
    protected TaskInstance jbpmTask;
    protected String body;
    protected String directive;
    protected String assigneeLogin;

    public NuxeoTask(TaskInstance jbpmTask, String link) {
        super(new Long(jbpmTask.getId()).toString(), jbpmTask.getActorId(), jbpmTask.getCreate(), jbpmTask.getCreate(), link);
        this.jbpmTask = jbpmTask;
        this.directive = (String)jbpmTask.getVariableLocally(JbpmService.TaskVariableName.directive.name());
        List comments = jbpmTask.getComments();
        StringBuffer commentBuffer = new StringBuffer();
        if (jbpmTask.getDescription() != null) {
            commentBuffer.append(jbpmTask.getDescription());
            commentBuffer.append("\n\n");
        }
        if (comments != null && !comments.isEmpty()) {
            for (Comment comment : comments) {
                String commentAuthor = null;
                if (comment.getActorId() != null && (commentAuthor = comment.getActorId()).contains(":")) {
                    commentAuthor = commentAuthor.split(":")[1];
                }
                if (this.authorLogin == null) {
                    this.authorLogin = commentAuthor;
                }
                commentBuffer.append(commentAuthor);
                commentBuffer.append(" : ");
                AbstractTask.TASK_DATE_FORMAT.format(comment.getTime());
                commentBuffer.append("\n");
                commentBuffer.append(comment.getMessage());
                commentBuffer.append("^n");
            }
        }
        this.body = commentBuffer.toString();
        for (Object actor : jbpmTask.getPooledActors()) {
            String id = ((PooledActor)actor).getActorId();
            if (id.contains(":")) {
                id = id.split(":")[1];
            }
            if (this.assigneeLogin != null || id == null) continue;
            this.assigneeLogin = id;
            break;
        }
    }

    public String getAssigneeLogin() {
        return this.assigneeLogin;
    }

    public String getBody() {
        return this.body;
    }

    public Date getDueDate() {
        return this.jbpmTask.getDueDate();
    }

    public String getPriority() {
        int priority = this.jbpmTask.getPriority();
        return "(2) Normal";
    }

    public String getStatus() {
        return "In Progress";
    }

    public String getTitle() {
        return this.directive;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void translateDirective(WSSRequest request) {
        this.directive = TranslationHelper.getLabel(this.directive, request);
    }
}

