/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.wss.backend.AbstractNuxeoCoreBackend;
import org.nuxeo.ecm.platform.wss.backend.NuxeoListItem;
import org.nuxeo.ecm.platform.wss.backend.SimpleNuxeoBackend;
import org.nuxeo.ecm.platform.wss.service.WSSPlugableBackendManager;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.DWSMetaDataImpl;
import org.nuxeo.wss.spi.dws.Site;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchBasedVirtualRootBackend
extends AbstractNuxeoCoreBackend
implements WSSBackend {
    private static final Log log = LogFactory.getLog(SearchBasedVirtualRootBackend.class);
    protected Map<String, String> name2path = null;
    protected Map<String, SimpleNuxeoBackend> name2backend = new HashMap<String, SimpleNuxeoBackend>();
    protected String urlRoot;
    protected String query = "select * from Workspace where ecm:mixinType != 'HiddenInNavigation' AND  ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 order by ecm:path";

    public SearchBasedVirtualRootBackend(String urlRoot, String query) {
        this.urlRoot = urlRoot;
        if (query != null) {
            this.query = query;
        }
    }

    protected SimpleNuxeoBackend getBackend(String name) throws WSSException {
        try {
            SimpleNuxeoBackend backend = this.name2backend.get(name);
            if (backend == null) {
                String path = this.getName2path().get(name);
                if (path == null) {
                    throw new WSSException("unable to resolve path");
                }
                backend = new SimpleNuxeoBackend(path, this.urlRoot, this.getCoreSession());
                this.name2backend.put(name, backend);
            }
            return backend;
        }
        catch (Exception e) {
            throw new WSSException("Unable to get backend", (Throwable)e);
        }
    }

    protected WSSListItem createNode(String parentPath, String name, boolean folderish) throws WSSException {
        Path containerPath = new Path(parentPath);
        if (containerPath.segmentCount() == 0) {
            throw new WSSException("Can not create item at root");
        }
        String base = containerPath.segment(0);
        WSSListItem item = folderish ? this.getBackend(base).createFolder(containerPath.removeFirstSegments(1).toString(), name) : this.getBackend(base).createFileItem(containerPath.removeFirstSegments(1).toString(), name);
        ((NuxeoListItem)item).setVirtualRootNodeName(base);
        return item;
    }

    public WSSListItem createFileItem(String location, String name) throws WSSException {
        return this.createNode(location, name, false);
    }

    public WSSListItem createFolder(String location, String name) throws WSSException {
        return this.createNode(location, name, true);
    }

    public WSSListItem getItem(String location) throws WSSException {
        Path path = new Path(location);
        String base = path.segment(0);
        if (path.segmentCount() == 1) {
            try {
                String corePath = this.getName2path().get(base);
                DocumentModel doc = this.getCoreSession().getDocument((DocumentRef)new PathRef(corePath));
                NuxeoListItem item = WSSPlugableBackendManager.instance().createItem(doc, new Path(corePath).removeLastSegments(1).toString(), this.urlRoot);
                item.setVirtualName(base);
                return item;
            }
            catch (Exception e) {
                throw new WSSException("unable to resolve path", (Throwable)e);
            }
        }
        WSSListItem item = this.getBackend(base).getItem(path.removeFirstSegments(1).toString());
        ((NuxeoListItem)item).setVirtualRootNodeName(base);
        return item;
    }

    public List<WSSListItem> listItems(String location) throws WSSException {
        Path path = new Path(location);
        String base = path.segment(0);
        if ("/".equals(base) || base == null) {
            ArrayList<WSSListItem> items = new ArrayList<WSSListItem>();
            try {
                ArrayList<String> names = new ArrayList<String>();
                names.addAll(this.getName2path().keySet());
                Collections.sort(names);
                for (String name : names) {
                    String corePath = this.getName2path().get(name);
                    DocumentModel doc = this.getCoreSession().getDocument((DocumentRef)new PathRef(corePath));
                    NuxeoListItem item = WSSPlugableBackendManager.instance().createItem(doc, new Path(corePath).removeLastSegments(1).toString(), this.urlRoot);
                    item.setVirtualName(name);
                    items.add(item);
                }
                return items;
            }
            catch (Exception e) {
                throw new WSSException("error in listItems", (Throwable)e);
            }
        }
        List<WSSListItem> items = this.getBackend(base).listItems(path.removeFirstSegments(1).toString());
        for (WSSListItem item : items) {
            ((NuxeoListItem)item).setVirtualRootNodeName(base);
        }
        return items;
    }

    public WSSListItem moveItem(String oldLocation, String newLocation) throws WSSException {
        Path path = new Path(oldLocation);
        String base = path.segment(0);
        if (path.segmentCount() == 1) {
            throw new WSSException("can not move this item");
        }
        String baseDest = new Path(newLocation).segment(0);
        if (base.equals(baseDest)) {
            WSSListItem item = this.getBackend(base).moveItem(path.removeFirstSegments(1).toString(), new Path(newLocation).removeFirstSegments(1).toString());
            ((NuxeoListItem)item).setVirtualRootNodeName(base);
            return item;
        }
        NuxeoListItem sourceItem = (NuxeoListItem)this.getBackend(base).getItem(path.removeFirstSegments(1).toString());
        DocumentModel sourceDocument = sourceItem.getDoc();
        WSSListItem item = this.getBackend(baseDest).moveDocument(sourceDocument, new Path(newLocation).removeFirstSegments(1).toString());
        ((NuxeoListItem)item).setVirtualRootNodeName(baseDest);
        return item;
    }

    public void removeItem(String location) throws WSSException {
        Path path = new Path(location);
        String base = path.segment(0);
        if (path.segmentCount() == 1) {
            throw new WSSException("can not move this item");
        }
        this.getBackend(base).removeItem(path.removeFirstSegments(1).toString());
    }

    private boolean isHead(String path, List<String> paths, int idx) {
        int level = new Path(path).segmentCount();
        for (int i = idx; i >= 0; --i) {
            String other = paths.get(i);
            if (!path.contains(other) || new Path(other).segmentCount() != level - 1) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getName2path() throws ClientException, Exception {
        if (this.name2path == null) {
            this.name2path = new HashMap<String, String>();
            DocumentModelList docs = this.getCoreSession().query(this.query);
            ArrayList<String> paths = new ArrayList<String>();
            for (DocumentModel doc : docs) {
                paths.add(doc.getPathAsString());
            }
            ArrayList<String> heads = new ArrayList<String>();
            for (int idx = 0; idx < paths.size(); ++idx) {
                String path = (String)paths.get(idx);
                if (!this.isHead(path, paths, idx)) continue;
                heads.add(path);
            }
            for (String head : heads) {
                String headName;
                String name = headName = new Path(head).lastSegment();
                int idx = 1;
                while (this.name2path.containsKey(name)) {
                    name = headName + "-" + idx;
                    ++idx;
                }
                this.name2path.put(name, head);
            }
        }
        return this.name2path;
    }

    protected Map<String, SimpleNuxeoBackend> getName2backend() {
        return this.name2backend;
    }

    public DWSMetaData getMetaData(String url, WSSRequest request) throws WSSException {
        Path path = new Path(url);
        String base = path.segment(0);
        if (path.segmentCount() == 1) {
            throw new WSSException("unable to resolve path");
        }
        DWSMetaDataImpl metadata = (DWSMetaDataImpl)this.getBackend(base).getMetaData(path.removeFirstSegments(1).toString(), request);
        List docs = metadata.getDocuments();
        for (WSSListItem item : docs) {
            ((NuxeoListItem)item).setVirtualRootNodeName(base);
        }
        WSSListItem siteItem = metadata.getSite().getItem();
        ((NuxeoListItem)siteItem).setVirtualRootNodeName(base);
        return metadata;
    }

    public Site getSite(String location) throws WSSException {
        Path path = new Path(location);
        String base = path.segment(0);
        if (path.segmentCount() == 1) {
            throw new WSSException("unable to resolve path");
        }
        return this.getBackend(base).getSite(path.removeFirstSegments(1).toString());
    }
}

