/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.platform.wss.backend.NuxeoWSSBackend;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.AbstractWSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dummy.DummyWSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.Site;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualRootedBackend
extends AbstractWSSBackend
implements NuxeoWSSBackend {
    protected String root;
    protected NuxeoWSSBackend realBackend;
    protected WSSListItem rootItem;
    protected DummyWSSListItem nuxeoRoot;

    public VirtualRootedBackend(String root, NuxeoWSSBackend realBackend) {
        this.root = root;
        this.realBackend = realBackend;
        this.rootItem = new DummyWSSListItem("", "WSS Root", null);
        this.nuxeoRoot = new DummyWSSListItem(root, "Nuxeo Server", null);
        this.nuxeoRoot.markAsSite();
    }

    public void discardChanges() throws WSSException {
        this.realBackend.discardChanges();
    }

    protected String getRealBackEndPath(String location) {
        Path path = new Path(location);
        while (this.root.equals(path.segment(0))) {
            path = path.removeFirstSegments(1);
        }
        return path.toString();
    }

    public WSSListItem getItem(String location) throws WSSException {
        if ("".equals(location) || "/".equals(location)) {
            return this.rootItem;
        }
        if (this.root.equals(location) || ("/" + this.root).equals(location) || ("/" + this.root + "/").equals(location)) {
            return this.nuxeoRoot;
        }
        return this.realBackend.getItem(this.getRealBackEndPath(location));
    }

    public List<WSSListItem> listItems(String location) throws WSSException {
        if ("".equals(location) || "/".equals(location)) {
            ArrayList<WSSListItem> children = new ArrayList<WSSListItem>();
            children.add((WSSListItem)this.nuxeoRoot);
            return children;
        }
        return this.realBackend.listItems(this.getRealBackEndPath(location));
    }

    public WSSListItem moveItem(String oldLocation, String newLocation) throws WSSException {
        if ("".equals(oldLocation) || "/".equals(oldLocation)) {
            throw new WSSException("Root item can not be moved");
        }
        if (this.root.equals(oldLocation) || ("/" + this.root).equals(oldLocation)) {
            throw new WSSException("Nuxeo root item can not be moved");
        }
        oldLocation = this.getRealBackEndPath(oldLocation);
        newLocation = this.getRealBackEndPath(newLocation);
        return this.realBackend.moveItem(oldLocation, newLocation);
    }

    public void removeItem(String location) throws WSSException {
        if ("".equals(location) || "/".equals(location)) {
            throw new WSSException("Root item can not be removed");
        }
        if (this.root.equals(location) || ("/" + this.root).equals(location)) {
            throw new WSSException("Nuxeo root item can not be removed");
        }
        this.realBackend.removeItem(this.getRealBackEndPath(location));
    }

    public boolean exists(String location) {
        if ("".equals(location) || "/".equals(location)) {
            return true;
        }
        if (this.root.equals(location) || ("/" + this.root).equals(location)) {
            return true;
        }
        return this.realBackend.exists(this.getRealBackEndPath(location));
    }

    public WSSListItem createFolder(String parentPath, String name) throws WSSException {
        if ("".equals(parentPath) || "/".equals(parentPath)) {
            throw new WSSException("Root item can not be removed");
        }
        if (this.root.equals(parentPath) || ("/" + this.root).equals(parentPath)) {
            throw new WSSException("Nuxeo root item can not be removed");
        }
        return this.realBackend.createFolder(this.getRealBackEndPath(parentPath), name);
    }

    public WSSListItem createFileItem(String parentPath, String name) throws WSSException {
        if ("".equals(parentPath) || "/".equals(parentPath)) {
            throw new WSSException("Root item can not be removed");
        }
        if (this.root.equals(parentPath) || ("/" + this.root).equals(parentPath)) {
            throw new WSSException("Nuxeo root item can not be removed");
        }
        return this.realBackend.createFileItem(this.getRealBackEndPath(parentPath), name);
    }

    @Override
    public void saveChanges(boolean release) throws WSSException {
        this.realBackend.saveChanges(release);
    }

    public void saveChanges() throws WSSException {
        this.realBackend.saveChanges();
    }

    @Override
    public void discardChanges(boolean release) throws WSSException {
        this.realBackend.discardChanges(release);
    }

    public DWSMetaData getMetaData(String location, WSSRequest request) throws WSSException {
        return this.realBackend.getMetaData(this.getRealBackEndPath(location), request);
    }

    public Site getSite(String location) throws WSSException {
        return this.realBackend.getSite(this.getRealBackEndPath(location));
    }
}

