/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.jbpm;

import java.util.ArrayList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;

public class ChangePermissionUnrestricted
extends UnrestrictedSessionRunner {
    private final DocumentModel document;
    private final NuxeoPrincipal principal;
    private final String aclName;
    private final String[] validators;

    public ChangePermissionUnrestricted(CoreSession session, DocumentModel document, String[] validators, NuxeoPrincipal principal, String aclName) {
        super(session);
        this.document = document;
        this.validators = validators;
        this.principal = principal;
        this.aclName = aclName;
    }

    public void run() throws ClientException {
        ArrayList<UserEntryImpl> userEntries = new ArrayList<UserEntryImpl>();
        for (String validator : this.validators) {
            UserEntryImpl ue = new UserEntryImpl(validator);
            ue.addPrivilege("Read", true, false);
            userEntries.add(ue);
            ue = new UserEntryImpl(validator);
            ue.addPrivilege("Write", true, false);
            userEntries.add(ue);
        }
        UserEntryImpl ue = new UserEntryImpl(this.principal.getName());
        ue.addPrivilege("Read", true, false);
        userEntries.add(ue);
        UserEntryImpl everyoneElse = new UserEntryImpl("Everyone");
        everyoneElse.addPrivilege("Write", false, false);
        userEntries.add(everyoneElse);
        UserEntryImpl everyoneView = new UserEntryImpl("Everyone");
        everyoneView.addPrivilege("Read", false, false);
        userEntries.add(everyoneView);
        ACP acp = this.document.getACP();
        acp.setRules(this.aclName, userEntries.toArray(new UserEntry[0]));
        this.session.setACP(this.document.getRef(), acp, true);
        this.session.save();
    }
}

