/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.jbpm;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.api.PublishingException;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreProxyFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.jbpm.ChangePermissionUnrestricted;
import org.nuxeo.ecm.platform.publisher.jbpm.DeleteDocumentUnrestricted;
import org.nuxeo.ecm.platform.publisher.jbpm.PublishUnrestricted;
import org.nuxeo.ecm.platform.publisher.jbpm.RemoveACLUnrestricted;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreProxyWithWorkflowFactory
extends CoreProxyFactory
implements PublishedDocumentFactory {
    public static final String TASK_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String ACL_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    protected JbpmService jbpmService;
    protected UserManager userManager;
    protected EventProducer eventProducer;

    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        DocumentModel proxy = this.publish(doc, targetNode, params);
        SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        if (!this.isValidator(proxy, principal)) {
            try {
                this.notifyEvent(PublishingEvent.documentWaitingPublication, proxy, this.coreSession);
                this.restrictPermission(proxy, principal, this.coreSession);
                this.createTask(proxy, this.coreSession, principal);
                publishedDocument.setPending(true);
            }
            catch (PublishingValidatorException e) {
                throw new PublishingException((Throwable)e);
            }
            catch (NuxeoJbpmException e) {
                throw new PublishingException((Throwable)e);
            }
        } else {
            this.notifyEvent(PublishingEvent.documentPublished, proxy, this.coreSession);
        }
        return publishedDocument;
    }

    protected DocumentModel publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        DocumentModel targetDocModel;
        if (targetNode instanceof CoreFolderPublicationNode) {
            CoreFolderPublicationNode coreNode = (CoreFolderPublicationNode)targetNode;
            targetDocModel = coreNode.getTargetDocumentModel();
        } else {
            targetDocModel = this.coreSession.getDocument((DocumentRef)new PathRef(targetNode.getPath()));
        }
        boolean overwriteProxy = params == null || !params.containsKey("overwriteExistingProxy") || Boolean.parseBoolean(params.get("overwriteExistingProxy"));
        PublishUnrestricted publisher = new PublishUnrestricted(this.coreSession, doc, targetDocModel, overwriteProxy);
        publisher.runUnrestricted();
        return publisher.getModel();
    }

    protected boolean isValidator(DocumentModel document, NuxeoPrincipal principal) throws PublishingException {
        try {
            String[] validators;
            for (String s : validators = this.getValidatorsFor(document)) {
                if (!principal.getName().equals(s) && !principal.isMemberOf(s)) continue;
                return true;
            }
        }
        catch (PublishingValidatorException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    protected void restrictPermission(DocumentModel newProxy, NuxeoPrincipal principal, CoreSession coreSession) throws PublishingValidatorException, PublishingException {
        ChangePermissionUnrestricted permissionChanger = new ChangePermissionUnrestricted(coreSession, newProxy, this.getValidatorsFor(newProxy), principal, "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
        try {
            permissionChanger.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void createTask(DocumentModel document, CoreSession session, NuxeoPrincipal principal) throws PublishingValidatorException, NuxeoJbpmException, PublishingException {
        TaskInstance ti = new TaskInstance();
        String[] actorIds = this.getValidatorsFor(document);
        ArrayList<String> prefixedActorIds = new ArrayList<String>();
        for (String s : actorIds) {
            String prefix;
            if (s.contains(":")) {
                prefixedActorIds.add(s);
                continue;
            }
            UserManager userManager = this.getUserManager();
            try {
                prefix = userManager.getPrincipal(s) == null ? "group:" : "user:";
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            prefixedActorIds.add(prefix + s);
        }
        ti.setPooledActors(prefixedActorIds.toArray(new String[prefixedActorIds.size()]));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(JbpmService.VariableName.documentId.name(), document.getId());
        variables.put(JbpmService.VariableName.documentRepositoryName.name(), document.getRepositoryName());
        variables.put(JbpmService.VariableName.initiator.name(), principal.getName());
        ti.setVariables(variables);
        ti.setName("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
        ti.setCreate(new Date());
        this.getJbpmService().saveTaskInstances(Collections.singletonList(ti));
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, document);
        ctx.setProperty("recipients", (Serializable)actorIds);
        try {
            this.getEventProducer().fireEvent(ctx.newEvent("worfklowTaskAssigned"));
            this.getEventProducer().fireEvent(ctx.newEvent("workflowTaskStart"));
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.userManager;
    }

    protected JbpmService getJbpmService() {
        if (this.jbpmService == null) {
            try {
                this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Jbpm service is not deployed.", e);
            }
        }
        return this.jbpmService;
    }

    protected EventProducer getEventProducer() throws ClientException {
        if (this.eventProducer == null) {
            try {
                this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.eventProducer;
    }

    protected void notifyEvent(PublishingEvent event, DocumentModel doc, CoreSession coreSession) throws PublishingException {
        try {
            this.notifyEvent(event.name(), null, null, null, doc, coreSession);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void notifyEvent(String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm, CoreSession coreSession) throws ClientException {
        EventProducer evtProducer;
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        properties.put("repositoryName", (Serializable)((Object)dm.getRepositoryName()));
        properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
        properties.put("documentLifeCycle", (Serializable)((Object)dm.getCurrentLifeCycleState()));
        DocumentEventContext ctx = new DocumentEventContext(coreSession, coreSession.getPrincipal(), dm);
        ctx.setProperties(properties);
        ctx.setComment(comment);
        ctx.setCategory(category);
        Event event = ctx.newEvent(eventId);
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        try {
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        try {
            this.removeACL(proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationApproved);
            this.notifyEvent(PublishingEvent.documentPublicationApproved, proxy, this.coreSession);
            this.notifyEvent(PublishingEvent.documentPublished, proxy, this.coreSession);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
        ((SimpleCorePublishedDocument)publishedDocument).setPending(false);
    }

    protected void removeACL(DocumentModel document, CoreSession coreSession) throws PublishingException {
        try {
            RemoveACLUnrestricted remover = new RemoveACLUnrestricted(coreSession, document, "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
            remover.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void endTask(DocumentModel document, NuxeoPrincipal currentUser, CoreSession session, String comment, PublishingEvent event) throws PublishingException {
        try {
            List tis = this.getJbpmService().getTaskInstances(document, currentUser, null);
            String initiator = null;
            for (TaskInstance ti : tis) {
                if (!ti.getName().equals("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory")) continue;
                initiator = (String)ti.getVariable(JbpmService.VariableName.initiator.name());
                ti.end();
                this.jbpmService.saveTaskInstances(Collections.singletonList(ti));
                break;
            }
            GetsProxySourceDocumentsUnrestricted runner = new GetsProxySourceDocumentsUnrestricted(session, document);
            runner.runUnrestricted();
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            if (initiator != null) {
                properties.put("recipients", (Serializable)new String[]{initiator});
            }
            this.notifyEvent(event.name(), properties, comment, null, runner.liveDocument, session);
        }
        catch (NuxeoJbpmException e) {
            throw new PublishingException((Throwable)e);
        }
        catch (ClientException ce) {
            throw new PublishingException((Throwable)ce);
        }
    }

    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        try {
            this.notifyEvent(PublishingEvent.documentPublicationRejected, proxy, this.coreSession);
            this.removeProxy(proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationRejected);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void removeProxy(DocumentModel doc, CoreSession coreSession) throws PublishingException {
        try {
            DeleteDocumentUnrestricted deleter = new DeleteDocumentUnrestricted(coreSession, doc);
            deleter.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    public PublishedDocument wrapDocumentModel(DocumentModel doc) throws ClientException {
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.wrapDocumentModel(doc);
        if (!this.isPublished((PublishedDocument)publishedDocument)) {
            publishedDocument.setPending(true);
        }
        return publishedDocument;
    }

    protected boolean isPublished(PublishedDocument publishedDocument) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        try {
            List tis = this.getJbpmService().getTaskInstances(proxy, (NuxeoPrincipal)null, null);
            for (TaskInstance ti : tis) {
                if (!ti.getName().equals("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory")) continue;
                return false;
            }
        }
        catch (NuxeoJbpmException e) {
            throw new PublishingException((Throwable)e);
        }
        return true;
    }

    public boolean canManagePublishing(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return proxy.isProxy() && this.hasValidationTask(proxy, currentUser);
    }

    protected boolean hasValidationTask(DocumentModel proxy, NuxeoPrincipal currentUser) throws ClientException {
        assert (currentUser != null);
        try {
            List tis = this.getJbpmService().getTaskInstances(proxy, currentUser, null);
            for (TaskInstance ti : tis) {
                if (!ti.getName().equals("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory")) continue;
                return true;
            }
        }
        catch (NuxeoJbpmException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    public boolean hasValidationTask(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return this.hasValidationTask(proxy, currentUser);
    }

    private class GetsProxySourceDocumentsUnrestricted
    extends UnrestrictedSessionRunner {
        public DocumentModel liveDocument;
        private DocumentModel sourceDocument;
        private DocumentModel document;

        public GetsProxySourceDocumentsUnrestricted(CoreSession session, DocumentModel proxy) {
            super(session);
            this.document = proxy;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument((DocumentRef)new IdRef(this.document.getSourceId()));
            this.liveDocument = this.session.getDocument((DocumentRef)new IdRef(this.sourceDocument.getSourceId()));
        }
    }
}

