/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.SpaceProvider;
import org.nuxeo.ecm.spaces.api.Univers;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;
import org.nuxeo.ecm.spaces.api.exceptions.UniversNotFoundException;
import org.nuxeo.ecm.spaces.core.impl.UniversProvider;
import org.nuxeo.ecm.spaces.core.impl.contribs.SpaceContribDescriptor;
import org.nuxeo.ecm.spaces.core.impl.contribs.UniversContribDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceManagerImpl
extends DefaultComponent
implements SpaceManager {
    private static final Log LOGGER = LogFactory.getLog(SpaceManagerImpl.class);
    private static final String UNIVERS_CONTRIB = "universContrib";
    private static final String SPACE_CONTRIB = "spaceContrib";
    private List<UniversContribDescriptor> universProvider = new ArrayList<UniversContribDescriptor>();
    private List<SpaceContribDescriptor> spaceProvider = new ArrayList<SpaceContribDescriptor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (UNIVERS_CONTRIB.equals(extensionPoint)) {
            UniversContribDescriptor descriptor = (UniversContribDescriptor)contribution;
            if (descriptor.isRemove()) {
                this.removeUniversDescriptor(descriptor);
            } else {
                this.manageUniversDescriptor(descriptor);
            }
        } else if (SPACE_CONTRIB.equals(extensionPoint)) {
            SpaceContribDescriptor descriptor = (SpaceContribDescriptor)contribution;
            this.manageSpaceDescriptor(descriptor);
        }
    }

    private void removeUniversDescriptor(UniversContribDescriptor descriptor) {
        for (UniversContribDescriptor contrib : this.universProvider) {
            if (!descriptor.getName().equals(contrib.getName())) continue;
            this.universProvider.remove(contrib);
            break;
        }
    }

    private synchronized void manageUniversDescriptor(UniversContribDescriptor descriptor) {
        this.universProvider.add(descriptor);
    }

    private synchronized void manageSpaceDescriptor(SpaceContribDescriptor descriptor) {
        this.spaceProvider.add(descriptor);
        Collections.sort(this.spaceProvider);
    }

    public List<Univers> getUniversList(CoreSession session) throws SpaceException {
        ArrayList<Univers> list = new ArrayList<Univers>();
        for (UniversContribDescriptor descriptor : this.universProvider) {
            try {
                list.addAll(descriptor.getProvider().getAll(session));
            }
            catch (Exception e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public Univers getUnivers(String name, CoreSession coreSession) throws UniversNotFoundException {
        for (UniversContribDescriptor descriptor : this.universProvider) {
            try {
                UniversProvider provider = descriptor.getProvider();
                return provider.getUnivers(name, coreSession);
            }
            catch (UniversNotFoundException e) {
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to get the provider for : " + descriptor.getName()));
            }
        }
        throw new UniversNotFoundException("No Univers with name : '" + name + "' was found");
    }

    public List<Space> getSpacesForUnivers(Univers univers, CoreSession coreSession) throws SpaceException {
        ArrayList<Space> list = new ArrayList<Space>();
        for (SpaceContribDescriptor descriptor : this.spaceProvider) {
            if (!descriptor.matches(univers.getName())) continue;
            try {
                list.addAll(descriptor.getProvider().getAll(coreSession));
            }
            catch (SpaceNotFoundException e) {
            }
            catch (InstantiationException e) {
                LOGGER.warn((Object)("Unable instanciate provider : " + descriptor.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn((Object)("Unable to instanciate provider : " + descriptor.getName()), (Throwable)e);
            }
        }
        return list;
    }

    public Space getSpaceFromId(String spaceId, CoreSession session) throws SpaceException {
        IdRef spaceRef = new IdRef(spaceId);
        try {
            if (session.exists((DocumentRef)spaceRef)) {
                return (Space)session.getDocument((DocumentRef)spaceRef).getAdapter(Space.class);
            }
            throw new SpaceNotFoundException();
        }
        catch (ClientException e) {
            throw new SpaceNotFoundException();
        }
    }

    public Space getSpace(String name, SpaceProvider provider, CoreSession session) throws SpaceException {
        for (SpaceContribDescriptor desc : this.spaceProvider) {
            try {
                Space space = desc.getProvider().getSpace(name, session);
                if (space == null) continue;
                return space;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to query provider " + desc.getName()), (Throwable)e);
            }
        }
        throw new SpaceNotFoundException();
    }

    public List<SpaceProvider> getSpacesProvider(Univers univers) {
        ArrayList<SpaceProvider> result = new ArrayList<SpaceProvider>();
        for (SpaceContribDescriptor desc : this.spaceProvider) {
            try {
                if (!desc.matches(univers.getName())) continue;
                result.add(desc.getProvider());
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to instanciate " + desc.getName()), (Throwable)e);
            }
        }
        return result;
    }

    public List<SpaceProvider> getSpacesProviders() {
        ArrayList<SpaceProvider> result = new ArrayList<SpaceProvider>();
        for (SpaceContribDescriptor desc : this.spaceProvider) {
            try {
                result.add(desc.getProvider());
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to instanciate " + desc.getName()), (Throwable)e);
            }
        }
        return result;
    }

    public String getProviderName(SpaceProvider provider) {
        for (SpaceContribDescriptor desc : this.spaceProvider) {
            try {
                if (!desc.getProvider().equals(provider)) continue;
                return desc.getName();
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to instanciate " + desc.getName()), (Throwable)e);
            }
        }
        return null;
    }

    public Univers getUniversFromId(String universId, CoreSession session) throws SpaceException {
        IdRef spaceRef = new IdRef(universId);
        try {
            if (session.exists((DocumentRef)spaceRef)) {
                return (Univers)session.getDocument((DocumentRef)spaceRef).getAdapter(Univers.class);
            }
            throw new SpaceNotFoundException();
        }
        catch (ClientException e) {
            throw new SpaceNotFoundException();
        }
    }

    public Space getSpace(String name, Univers univers, CoreSession session) throws SpaceException {
        for (SpaceProvider provider : this.getSpacesProvider(univers)) {
            try {
                return provider.getSpace(name, session);
            }
            catch (SpaceNotFoundException e) {
            }
        }
        throw new SpaceNotFoundException();
    }
}

