/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Univers;
import org.nuxeo.ecm.spaces.api.exceptions.UniversNotFoundException;
import org.nuxeo.ecm.spaces.core.impl.UniversProvider;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.VirtualUnivers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualUniversProvider
implements UniversProvider {
    Map<String, Univers> universes = new HashMap<String, Univers>();

    @Override
    public Univers getUnivers(String name, CoreSession session) throws ClientException {
        if (this.universes.containsKey(name)) {
            return this.universes.get(name);
        }
        throw new UniversNotFoundException();
    }

    @Override
    public void initialize(Map<String, String> params) throws Exception {
        if (!params.containsKey("names")) {
            throw new Exception("Unable to initialize virtual universe");
        }
        String names = params.get("names");
        if (names.indexOf("|") != -1) {
            for (String name : names.split("|")) {
                this.universes.put(name, (Univers)new VirtualUnivers(name));
            }
        } else {
            this.universes.put(names, (Univers)new VirtualUnivers(names));
        }
    }

    @Override
    public List<Univers> getAll(CoreSession session) throws ClientException {
        ArrayList<Univers> result = new ArrayList<Univers>();
        result.addAll(this.universes.values());
        return result;
    }
}

