/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.impl.docwrapper;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.spaces.api.AbstractGadget;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocGadgetImpl
extends AbstractGadget {
    private static final String GADGET_CATEGORY = "gadget:category";
    private static final String GADGET_PLACEID = "gadget:placeID";
    private static final String GADGET_POSITION = "gadget:position";
    private static final String GADGET_COLLAPSED = "gadget:collapsed";
    private static final String GADGET_HEIGHT = "gadget:height";
    private static final String GADGET_PREFERENCES = "gadget:props";
    private static final String GADGET_NAME = "gadget:name";
    private static final String GADGET_URL = "gadget:url";
    private static final String GADGET_HTML = "gadget:htmlContent";
    public static final String TYPE = "Gadget";
    private final DocumentModel doc;
    private static final Log LOGGER = LogFactory.getLog(DocGadgetImpl.class);

    public DocGadgetImpl(DocumentModel doc) {
        this.doc = doc;
    }

    public DocumentModel getDocument() {
        return this.doc;
    }

    public String getCategory() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue(GADGET_CATEGORY));
    }

    public URL getDefinitionUrl() throws ClientException {
        URL url = null;
        try {
            GadgetService service = (GadgetService)Framework.getService(GadgetService.class);
            url = service.getGadgetDefinition(this.getName());
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to get URL from gadgetService", (Throwable)e);
        }
        if (url == null) {
            try {
                url = new URL((String)((Object)this.doc.getPropertyValue(GADGET_URL)));
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Malformed URL for gadget " + this.getId()), (Throwable)e);
                return null;
            }
        }
        return url;
    }

    public String getDescription() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue(GADGET_NAME));
    }

    public String getOwner() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue("dc:creator"));
    }

    public Space getParent() throws ClientException {
        CoreSession session = this.doc.getCoreSession();
        DocumentModel parent = session.getDocument(this.doc.getParentRef());
        return (Space)parent.getAdapter(Space.class);
    }

    public String getPlaceId() throws ClientException {
        String result = (String)((Object)this.doc.getPropertyValue(GADGET_PLACEID));
        if (result == null) {
            return "";
        }
        return result;
    }

    public int getPosition() throws ClientException {
        Long result = (Long)this.doc.getPropertyValue(GADGET_POSITION);
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }

    public Map<String, String> getPreferences() throws ClientException {
        ArrayList list = (ArrayList)this.doc.getPropertyValue(GADGET_PREFERENCES);
        if (list == null) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map map : list) {
            String key = (String)map.get("name");
            String value = (String)map.get("value");
            ret.put(key, value);
        }
        return ret;
    }

    public String getTitle() throws ClientException {
        return this.doc.getTitle();
    }

    public boolean isCollapsed() throws ClientException {
        Boolean result = (Boolean)this.doc.getPropertyValue(GADGET_COLLAPSED);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean isEqualTo(Gadget gadget) {
        return gadget.getId().equals(this.getId());
    }

    public void setCategory(String category) throws ClientException {
        this.doc.setPropertyValue(GADGET_CATEGORY, (Serializable)((Object)category));
    }

    public void setCollapsed(boolean collapsed) throws ClientException {
        this.doc.setPropertyValue(GADGET_COLLAPSED, (Serializable)Boolean.valueOf(collapsed));
    }

    public void setDefinitionUrl(URL url) throws ClientException {
        this.doc.setPropertyValue(GADGET_URL, (Serializable)((Object)url.toString()));
    }

    public void setDescription(String description) throws ClientException {
        this.doc.setPropertyValue("dc:desctription", (Serializable)((Object)description));
    }

    public void setName(String name) throws ClientException {
        this.doc.setPropertyValue(GADGET_NAME, (Serializable)((Object)name));
    }

    public void setPlaceId(String placeId) throws ClientException {
        this.doc.setPropertyValue(GADGET_PLACEID, (Serializable)((Object)placeId));
    }

    public void setPosition(int position) throws ClientException {
        this.doc.setPropertyValue(GADGET_POSITION, (Serializable)Integer.valueOf(position));
    }

    public void setPreferences(Map<String, String> prefs) throws ClientException {
        ArrayList listPrefs = new ArrayList();
        for (String key : prefs.keySet()) {
            HashMap<String, String> keyValue = new HashMap<String, String>();
            keyValue.put("name", key);
            keyValue.put("value", prefs.get(key));
            listPrefs.add(keyValue);
        }
        this.doc.setPropertyValue(GADGET_PREFERENCES, listPrefs);
    }

    public void setTitle(String title) throws ClientException {
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    public int getHeight() throws ClientException {
        Long result = (Long)this.doc.getPropertyValue(GADGET_HEIGHT);
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }

    public void setHeight(int height) throws ClientException {
        this.doc.setPropertyValue(GADGET_HEIGHT, (Serializable)Integer.valueOf(height));
    }

    public void copyFrom(Gadget gadget) throws ClientException {
        this.setTitle(gadget.getTitle());
        this.setCategory(gadget.getCategory());
        this.setPlaceId(gadget.getPlaceId());
        this.setPosition(gadget.getPosition());
        this.setHeight(gadget.getHeight());
        this.setCollapsed(gadget.isCollapsed());
        this.setHtmlContent(gadget.getHtmlContent());
        Map preferences = gadget.getPreferences();
        for (String key : preferences.keySet()) {
            String value = (String)preferences.get(key);
            if (value == null) continue;
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("Unable to decode pref value : " + value));
            }
        }
        this.setPreferences(preferences);
    }

    public String getHtmlContent() throws ClientException {
        String result = (String)((Object)this.doc.getPropertyValue(GADGET_HTML));
        if (result == null) {
            return "";
        }
        return result;
    }

    public void setHtmlContent(String htmlContent) throws ClientException {
        this.doc.setPropertyValue(GADGET_HTML, (Serializable)((Object)htmlContent));
    }

    public String getViewer() throws ClientException {
        return this.doc.getCoreSession().getPrincipal().getName();
    }

    public boolean hasPermission(String permissioName) throws ClientException {
        return this.doc.getCoreSession().hasPermission(this.doc.getRef(), permissioName);
    }
}

