/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.impl.docwrapper;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.SpaceProvider;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocSpaceImpl
implements Space {
    protected final DocumentModel doc;
    private boolean readOnly = false;
    public static final String TYPE = "Space";
    protected static final String SPACE_THEME = "space:theme";
    protected static final String SPACE_LAYOUT = "space:layout";
    protected static final String SPACE_CATEGORY = "space:categoryId";
    protected static final String SPACE_VERSIONNABLE = "space:versionnable";
    protected static final String PUBLICATION_DATE = "dc:valid";
    private static final Log LOGGER = LogFactory.getLog(DocSpaceImpl.class);

    protected DocSpaceImpl(DocumentModel doc) {
        this.doc = doc;
    }

    public String getLayout() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue(SPACE_LAYOUT));
    }

    public String getCategory() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue(SPACE_CATEGORY));
    }

    public boolean isEqualTo(Space space) {
        return space.getId() != null && space.getId().equals(this.getId());
    }

    public String getTheme() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue(SPACE_THEME));
    }

    protected boolean getBooleanProperty(String xpath) {
        try {
            Serializable value = this.doc.getPropertyValue(xpath);
            if (value == null) {
                return false;
            }
            return (Boolean)value;
        }
        catch (ClientException e) {
            return false;
        }
    }

    public String getDescription() {
        try {
            return (String)((Object)this.doc.getPropertyValue("dc:description"));
        }
        catch (ClientException e) {
            return "";
        }
    }

    public List<Gadget> getGadgets() throws ClientException {
        ArrayList<Gadget> result = new ArrayList<Gadget>();
        CoreSession session = this.doc.getCoreSession();
        DocumentModelList gadgets = session.getChildren(this.doc.getRef(), "Gadget");
        for (DocumentModel gadget : gadgets) {
            Gadget item = (Gadget)gadget.getAdapter(Gadget.class);
            if (item != null) {
                result.add(item);
                continue;
            }
            LOGGER.warn((Object)("Unable to find gadget adapter for doc : " + gadget.getId()));
        }
        return result;
    }

    public Gadget getGadget(String gadgetName) throws ClientException {
        DocumentModelList gadgets = this.doc.getCoreSession().getChildren(this.doc.getRef(), "Gadget");
        for (DocumentModel doc : gadgets) {
            Gadget g = (Gadget)doc.getAdapter(Gadget.class);
            if (g == null || !g.getName().equals(gadgetName)) continue;
            return g;
        }
        return null;
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() {
        return this.doc.getName();
    }

    public String getOwner() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue("dc:creator"));
    }

    public String getTitle() throws ClientException {
        return this.doc.getTitle();
    }

    private CoreSession session() {
        return this.doc.getCoreSession();
    }

    public String getViewer() {
        return this.session().getPrincipal().getName();
    }

    public boolean hasPermission(String permissionName) throws ClientException {
        return this.session().hasPermission(this.doc.getRef(), permissionName);
    }

    public boolean isReadOnly() throws ClientException {
        return this.readOnly;
    }

    public void setLayout(String name) throws ClientException {
        this.doc.setPropertyValue(SPACE_LAYOUT, (Serializable)((Object)name));
    }

    public void save(Gadget gadget) throws ClientException {
        DocumentModel docGadget = null;
        IdRef gadgetRef = new IdRef(gadget.getId());
        if (this.session().exists((DocumentRef)gadgetRef)) {
            docGadget = this.session().getDocument((DocumentRef)gadgetRef);
            Gadget sessionGadget = (Gadget)docGadget.getAdapter(Gadget.class);
            sessionGadget.copyFrom(gadget);
        }
        if (docGadget == null) {
            throw new ClientException("Unable to save gadget: did not find the gadget in DB");
        }
        this.session().saveDocument(docGadget);
        this.session().save();
    }

    public Gadget createGadget(String gadgetName) throws ClientException {
        CoreSession session = this.session();
        DocumentModel doc = session.createDocumentModel(this.doc.getPathAsString(), gadgetName, "Gadget");
        doc = session.createDocument(doc);
        Gadget gadget = (Gadget)doc.getAdapter(Gadget.class);
        try {
            GadgetService service = (GadgetService)Framework.getService(GadgetService.class);
            URL def = service.getGadgetDefinition(gadgetName);
            gadget.setDefinitionUrl(new URL(def.toString()));
            gadget.setName(gadgetName);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to find gadget URL for " + gadgetName + " (ID:" + doc.getId() + ")"));
        }
        session.saveDocument(doc);
        session.save();
        return gadget;
    }

    public Gadget createGadget(URL gadgetDefUrl) throws ClientException {
        CoreSession session = this.session();
        DocumentModel doc = session.createDocumentModel(this.doc.getPathAsString(), "url", "Gadget");
        doc = session.createDocument(doc);
        doc.setPropertyValue("gadget:url", (Serializable)((Object)gadgetDefUrl.toString()));
        session.saveDocument(doc);
        session.save();
        return (Gadget)doc.getAdapter(Gadget.class);
    }

    public DocumentModel getDocument() {
        return this.doc;
    }

    public static DocSpaceImpl createFromSpace(Space o, String path, CoreSession session) throws ClientException {
        DocumentModel doc = session.createDocumentModel(path, o.getName(), TYPE);
        return new DocSpaceImpl(doc);
    }

    public void remove(Gadget gadget) throws ClientException {
        IdRef ref;
        CoreSession session = this.doc.getCoreSession();
        DocumentModel gadgetDoc = session.getDocument((DocumentRef)(ref = new IdRef(gadget.getId())));
        if (gadgetDoc != null && gadgetDoc.getParentRef().equals(this.doc.getRef())) {
            session.removeDocument((DocumentRef)ref);
        }
    }

    public void save() throws ClientException {
        this.doc.getCoreSession().saveDocument(this.doc);
        this.doc.getCoreSession().save();
    }

    public Space copyFrom(Space space) throws ClientException {
        this.setLayout(space.getLayout());
        this.setTheme(space.getTheme());
        this.setDescription(space.getDescription());
        this.setTitle(space.getTitle());
        return this;
    }

    public void setDescription(String description) throws ClientException {
        this.doc.setPropertyValue("dc:description", (Serializable)((Object)description));
    }

    public void setTheme(String theme) throws ClientException {
        this.doc.setPropertyValue(SPACE_THEME, (Serializable)((Object)theme));
    }

    public void setTitle(String title) throws ClientException {
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    public void setCategory(String category) throws ClientException {
        this.doc.setPropertyValue(SPACE_CATEGORY, (Serializable)((Object)category));
    }

    public Calendar getPublicationDate() throws ClientException {
        return (Calendar)this.doc.getPropertyValue(PUBLICATION_DATE);
    }

    public void setPublicationDate(Calendar datePublication) throws ClientException {
        this.doc.setPropertyValue(PUBLICATION_DATE, (Serializable)datePublication);
    }

    public int compareTo(Space o) {
        try {
            Calendar dte1 = this.getPublicationDate();
            Calendar dte2 = o.getPublicationDate();
            return dte1.compareTo(dte2);
        }
        catch (ClientException e) {
            return 0;
        }
    }

    public void remove() throws ClientException {
        CoreSession session = this.doc.getCoreSession();
        session.removeDocument(this.doc.getRef());
        session.save();
    }

    public String getProviderName() throws ClientException {
        SpaceManager sm;
        try {
            sm = (SpaceManager)Framework.getService(SpaceManager.class);
        }
        catch (Exception e) {
            throw new SpaceException("Unable to get Space Manager", (Throwable)e);
        }
        List providers = sm.getSpacesProviders();
        for (SpaceProvider provider : providers) {
            try {
                if (provider.getSpace(this.getName(), this.session()) == null) continue;
                return sm.getProviderName(provider);
            }
            catch (SpaceNotFoundException e) {
            }
        }
        return null;
    }
}

