/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.spaces.core.impl.docwrapper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.DocGadgetImpl;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.DocSpaceImpl;
import org.nuxeo.ecm.spaces.core.impl.docwrapper.SpaceFactoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class SpacesAdapterComponent
extends DefaultComponent
implements DocumentAdapterFactory {
    public static final String NAME = SpacesAdapterComponent.class.getName();
    private static final Log log = LogFactory.getLog(SpacesAdapterComponent.class);
    Map<String, Class<? extends DocumentAdapterFactory>> factories = new HashMap<String, Class<? extends DocumentAdapterFactory>>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("factory".equals(extensionPoint)) {
            SpaceFactoryDescriptor desc = (SpaceFactoryDescriptor)contribution;
            this.factories.put(desc.getType(), desc.getKlass());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        SpaceFactoryDescriptor desc;
        if ("factory".equals(extensionPoint) && this.factories.containsKey((desc = (SpaceFactoryDescriptor)contribution).getType())) {
            this.factories.remove(desc.getType());
        }
    }

    public Object getAdapter(DocumentModel doc, Class itf) {
        if (Space.class.isAssignableFrom(itf)) {
            return this.getSpaceFactory(doc, itf);
        }
        if (doc.getType().equals("Gadget") && Gadget.class.isAssignableFrom(itf)) {
            return new DocGadgetImpl(doc);
        }
        return null;
    }

    private Object getSpaceFactory(DocumentModel doc, Class itf) {
        if (this.factories.containsKey(doc.getType())) {
            DocumentAdapterFactory factory;
            Class<? extends DocumentAdapterFactory> factoryKlass = this.factories.get(doc.getType());
            try {
                factory = factoryKlass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Unable to instanciate factory : " + factoryKlass.getCanonicalName()), (Throwable)e);
                return null;
            }
            return factory.getAdapter(doc, itf);
        }
        try {
            SchemaManager sm = (SchemaManager)Framework.getService(SchemaManager.class);
            Set types = sm.getDocumentTypeNamesExtending("Space");
            if (types.contains(doc.getType())) {
                return new DocSpaceImpl(doc);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Unable to get SchemaManager", (Throwable)e);
            return null;
        }
    }
}

