/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNuxeoUriResolver
implements UriResolver {
    private static final String NUXEO = "nuxeo/";
    private static final Log log = LogFactory.getLog(DefaultNuxeoUriResolver.class);
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    private DocumentViewCodecManager viewCodecManager;

    public DefaultNuxeoUriResolver() {
        try {
            this.viewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<URI> getSearchURI(URI uri) throws AnnotationException {
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        URI translatedUri = null;
        CoreSession session = null;
        try {
            IdRef idRef = view.getDocumentLocation().getIdRef();
            if (idRef == null) {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                session = mgr.getDefaultRepository().open();
                DocumentModel docModel = session.getDocument(view.getDocumentLocation().getDocRef());
                idRef = docModel.getRef();
            }
            translatedUri = this.translator.getUriFromDocumentView(view.getDocumentLocation().getServerName(), (DocumentRef)idRef);
            if (session == null) return Collections.singletonList(translatedUri);
        }
        catch (Exception e) {
            try {
                throw new AnnotationException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                CoreInstance.getInstance().close(session);
                throw throwable;
            }
        }
        CoreInstance.getInstance().close(session);
        return Collections.singletonList(translatedUri);
    }

    public URI translateFromGraphURI(URI uri, String baseUrl) throws AnnotationException {
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        if (view == null || baseUrl == null) {
            return uri;
        }
        String url = this.viewCodecManager.getUrlFromDocumentView(view, true, baseUrl);
        URI u = null;
        try {
            u = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new AnnotationException((Throwable)e);
        }
        return u;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URI translateToGraphURI(URI uri) throws AnnotationException {
        URI result;
        if (uri.toString().startsWith("urn")) {
            return uri;
        }
        DocumentView view = this.viewCodecManager.getDocumentViewFromUrl(uri.toString(), true, this.getBaseUrl(uri));
        if (view == null) {
            return uri;
        }
        CoreSession session = null;
        try {
            IdRef idRef = view.getDocumentLocation().getIdRef();
            if (idRef == null) {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                session = mgr.getDefaultRepository().open();
                DocumentModel docModel = session.getDocument(view.getDocumentLocation().getDocRef());
                idRef = docModel.getRef();
            }
            result = this.translator.getUriFromDocumentView(view.getDocumentLocation().getServerName(), (DocumentRef)idRef);
            if (session == null) return result;
        }
        catch (Exception e) {
            try {
                throw new AnnotationException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                CoreInstance.getInstance().close(session);
                throw throwable;
            }
        }
        CoreInstance.getInstance().close(session);
        return result;
    }

    public String getBaseUrl(URI uri) throws AnnotationException {
        String url;
        try {
            url = uri.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new AnnotationException((Throwable)e);
        }
        return url.substring(0, url.lastIndexOf(NUXEO) + NUXEO.length());
    }

    public DocumentRef getDocumentRef(URI uri) throws AnnotationException {
        DocumentView view = null;
        if (this.translator.isNuxeoUrn(uri)) {
            view = this.translator.getDocumentViewFromUri(uri);
        } else {
            view = this.viewCodecManager.getDocumentViewFromUrl(uri.toString(), true, this.getBaseUrl(uri));
            if (view == null) {
                return null;
            }
        }
        DocumentLocation location = view.getDocumentLocation();
        return location.getDocRef();
    }

    public DocumentLocation getDocumentLocation(URI uri) throws AnnotationException {
        DocumentView view;
        if (this.translator.isNuxeoUrn(uri)) {
            view = this.translator.getDocumentViewFromUri(uri);
        } else {
            view = this.viewCodecManager.getDocumentViewFromUrl(uri.toString(), true, this.getBaseUrl(uri));
            if (view == null) {
                return null;
            }
        }
        return view.getDocumentLocation();
    }

    public URI getUri(DocumentView view, String baseUrl) throws URISyntaxException {
        return new URI(this.viewCodecManager.getUrlFromDocumentView(view, true, baseUrl));
    }
}

