/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.core;

import java.net.URI;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.DefaultNuxeoUriResolver;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.EventListener;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEventListener
implements EventListener {
    private List<AnnotatedDocumentEventListener> listeners;
    private final DefaultNuxeoUriResolver resolver = new DefaultNuxeoUriResolver();

    public void afterAnnotationCreated(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationCreated(this.getDocumentLocation(annotation), annotation);
        }
    }

    private DocumentLocation getDocumentLocation(Annotation annotation) throws AnnotationException {
        URI annotates = annotation.getAnnotates();
        return this.resolver.getDocumentLocation(annotates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnnotatedDocumentEventListener> getListeners() throws AnnotationException {
        if (this.listeners == null) {
            AnnotationEventListener annotationEventListener = this;
            synchronized (annotationEventListener) {
                AnnotationsRepositoryConfigurationService service;
                try {
                    service = (AnnotationsRepositoryConfigurationService)Framework.getService(AnnotationsRepositoryConfigurationService.class);
                }
                catch (Exception e) {
                    throw new AnnotationException((Throwable)e);
                }
                this.listeners = service.getEventListeners();
            }
        }
        return this.listeners;
    }

    public void afterAnnotationDeleted(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationDeleted(this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationRead(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationRead(this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationUpdated(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationUpdated(this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationCreated(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationCreated(this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationDeleted(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationDeleted(this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationRead(String annId) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationRead(annId);
        }
    }

    public void beforeAnnotationUpdated(Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationUpdated(this.getDocumentLocation(annotation), annotation);
        }
    }
}

