/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;

public class AnnotatedDocumentEventListenerImpl
implements AnnotatedDocumentEventListener {
    private static final Log log = LogFactory.getLog(AnnotatedDocumentEventListenerImpl.class);
    private static final String ANNOTATION_CREATED = "annotationCreated";
    private static final String ANNOTATION_UPDATED = "annotationUpdated";
    private static final String ANNOTATION_DELETED = "annotationDeleted";
    private transient EventService eventService;

    public void beforeAnnotationCreated(DocumentLocation documentLoc, Annotation annotation) {
    }

    public void beforeAnnotationDeleted(DocumentLocation documentLoc, Annotation annotation) {
    }

    public void beforeAnnotationRead(String annId) {
    }

    public void beforeAnnotationUpdated(DocumentLocation documentLoc, Annotation annotation) {
    }

    public void afterAnnotationCreated(DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent(ANNOTATION_CREATED, annotation, documentLoc);
    }

    public void afterAnnotationDeleted(DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent(ANNOTATION_DELETED, annotation, documentLoc);
    }

    public void afterAnnotationRead(DocumentLocation documentLoc, Annotation annotation) {
    }

    public void afterAnnotationUpdated(DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent(ANNOTATION_UPDATED, annotation, documentLoc);
    }

    protected void notifyEvent(String eventId, Annotation annotation, DocumentLocation documentLocation) {
        try {
            DocumentModel dm = this.getDocument(documentLocation);
            HashMap properties = new HashMap();
            DocumentEventContext ctx = new DocumentEventContext(null, (Principal)new NuxeoPrincipalImpl(annotation.getCreator()), dm);
            ctx.setRepositoryName(dm.getRepositoryName());
            ctx.setProperties(properties);
            ctx.setCategory("eventDocumentCategory");
            Event event = ctx.newEvent(eventId);
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)("Unable to send the " + eventId + " event"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModel getDocument(DocumentLocation docLoc) throws Exception {
        LoginContext loginContext = null;
        DocumentModel doc = null;
        try {
            loginContext = Framework.login();
            CoreSession session = this.getSession(docLoc.getServerName());
            doc = session.getDocument(docLoc.getDocRef());
            CoreInstance.getInstance().close(session);
        }
        finally {
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    log.error((Object)("Unable to logout: " + e.getMessage()));
                }
            }
        }
        return doc;
    }

    protected CoreSession getSession(String repoName) throws Exception {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repository = repositoryManager.getRepository(repoName);
        return repository.open();
    }
}

