/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree.directory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryContentProvider
implements ContentProvider {
    private static final long serialVersionUID = 1L;
    protected final Session session;

    public DirectoryContentProvider(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    protected void createQuery(DocumentModel parent, Map<String, Serializable> query) {
        String id = parent == null ? null : parent.getId();
        query.put("parent", (Serializable)((Object)id));
    }

    @Override
    public Object[] getElements(Object input) {
        if (input instanceof Directory) {
            return this.getChildren(null);
        }
        return this.getChildren(input);
    }

    @Override
    public Object[] getChildren(Object obj) {
        try {
            if (obj == null || obj instanceof DocumentModel) {
                DocumentModel parent = (DocumentModel)obj;
                HashMap<String, Serializable> args = new HashMap<String, Serializable>();
                this.createQuery(parent, args);
                DocumentModelList list = this.session.query(args);
                return list.toArray((Object[])new DocumentModel[list.size()]);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isContainer(Object obj) {
        if (obj instanceof DocumentModel) {
            return ((DocumentModel)obj).isFolder();
        }
        return false;
    }

    @Override
    public String getName(Object obj) {
        if (obj instanceof DocumentModel) {
            return ((DocumentModel)obj).getId();
        }
        return null;
    }

    @Override
    public String getLabel(Object obj) {
        if (obj instanceof DocumentModel) {
            return ((DocumentModel)obj).getName();
        }
        return null;
    }

    @Override
    public String[] getFacets(Object object) {
        return null;
    }
}

