/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.HibernateConfigurator;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagConfig;
import org.nuxeo.ecm.platform.tag.TagConfigurator;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.TagServiceInitializer;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.ecm.platform.tag.entity.DublincoreEntity;
import org.nuxeo.ecm.platform.tag.entity.TagEntity;
import org.nuxeo.ecm.platform.tag.entity.TaggingEntity;
import org.nuxeo.ecm.platform.tag.persistence.TagSchemaUpdater;
import org.nuxeo.ecm.platform.tag.persistence.TaggingProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagServiceImpl
extends DefaultComponent
implements TagService,
TagConfigurator {
    private static final Log log = LogFactory.getLog(TagServiceImpl.class);
    private static Boolean enabled = null;
    protected TagConfig config = new TagConfig();
    protected PersistenceProvider persistenceProvider;

    public void activate(ComponentContext context) throws Exception {
        enabled = null;
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener(new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
                ClassLoader nuxeoCL = TagServiceImpl.class.getClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(nuxeoCL);
                    if (TagServiceImpl.this.isEnabled()) {
                        TagServiceImpl.this.updateSchema();
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(jbossCL);
                    log.debug((Object)"JBoss ClassLoader restored");
                }
            }
        });
        TagServiceInitializer tagServiceInitializer = new TagServiceInitializer();
        tagServiceInitializer.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEnable() {
        LoginContext lc = null;
        try {
            lc = Framework.login();
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            if (rm.getDefaultRepository().supportsTags()) {
                log.info((Object)"Activating tag service");
                enabled = true;
            } else {
                enabled = false;
                log.warn((Object)"Default repository does not support Tag feature : Tag service won't be available.");
            }
        }
        catch (Exception e) {
            enabled = false;
            log.error((Object)"Unable to test repository for Tag feature.", (Throwable)e);
        }
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    log.error((Object)"Error during Framework.logout", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.deactivatePersistenceProvider();
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("configs".equals(extensionPoint)) {
            this.setConfig((TagConfig)contribution);
        }
    }

    @Override
    public void setConfig(TagConfig config) {
        this.config = config;
    }

    @Override
    public TagConfig getConfig() {
        return this.config;
    }

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            return this.persistenceProvider;
        }
        PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
        this.persistenceProvider = persistenceProviderFactory.newProvider("nxtags");
        return this.persistenceProvider;
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            return;
        }
        this.persistenceProvider.closePersistenceUnit();
        this.persistenceProvider = null;
    }

    public DocumentModel getRootTag(final CoreSession session) throws ClientException {
        return (DocumentModel)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<DocumentModel>(){

            public DocumentModel runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getRootTag(em, session);
            }
        });
    }

    public DocumentModel getRootTag(EntityManager em, CoreSession session) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Going to look for root tag");
        }
        UnrestrictedSessionCreateRootTag runner = new UnrestrictedSessionCreateRootTag(session);
        runner.runUnrestricted();
        if (runner.rootTagDocumentId == null) {
            throw new ClientException("Error creating the root tag document");
        }
        return session.getDocument((DocumentRef)new IdRef(runner.rootTagDocumentId));
    }

    public void tagDocument(final CoreSession session, final DocumentModel document, final String tagId, final boolean privateFlag) throws ClientException {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) throws ClientException {
                TagServiceImpl.this.tagDocument(em, session, document, tagId, privateFlag);
            }
        });
    }

    public void tagDocument(EntityManager em, CoreSession session, DocumentModel document, String tagId, boolean privateFlag) throws ClientException {
        if (null == document) {
            throw new ClientException("Can't tag document null.");
        }
        TaggingProvider provider = TaggingProvider.createProvider(em);
        TagEntity tagEntity = provider.getTagById(tagId);
        if (tagEntity == null) {
            throw new ClientException("Tag " + tagId + " doesn't exist");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to tag document " + document.getTitle() + " with " + tagEntity.getLabel()));
        }
        String user = TagServiceImpl.getUserName(session);
        if (provider.existTagging(tagId, document.getId(), user)) {
            log.warn((Object)String.format("Tag %s already applied on %s by %s, don't create it", tagEntity.getLabel(), document.getTitle(), user));
            return;
        }
        TaggingEntity taggingEntry = new TaggingEntity();
        String targetDocId = document.getId();
        if (document.isProxy()) {
            targetDocId = document.getSourceId();
        }
        DublincoreEntity dc = provider.getDcById(targetDocId);
        taggingEntry.setId(IdUtils.generateStringId());
        taggingEntry.setTag(tagEntity);
        taggingEntry.setTargetDocument(dc);
        taggingEntry.setCreationDate(new Date());
        taggingEntry.setAuthor(user);
        taggingEntry.setIsPrivate(privateFlag ? 1 : 0);
        TaggingProvider.createProvider(em).addTagging(taggingEntry);
    }

    protected static String getUserName(CoreSession session) throws ClientException {
        if (session == null) {
            throw new ClientException("No session available");
        }
        return session.getPrincipal().getName();
    }

    public DocumentModel getOrCreateTag(final CoreSession session, final DocumentModel parent, final String label, final boolean privateFlag) throws ClientException {
        return (DocumentModel)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<DocumentModel>(){

            public DocumentModel runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getOrCreateTag(em, session, parent, label, privateFlag);
            }
        });
    }

    public DocumentModel getOrCreateTag(EntityManager em, CoreSession session, DocumentModel parent, String label, boolean privateFlag) throws ClientException {
        if (parent == null) {
            log.warn((Object)"Can't create tag in null parent");
            throw new ClientException("Need a parent to create a tag");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to look for label " + label));
        }
        UnrestrictedSessionCreateTag runner = new UnrestrictedSessionCreateTag(session, parent, label, privateFlag);
        runner.runUnrestricted();
        if (runner.tagDocument == null) {
            throw new ClientException("Error creating the tag document");
        }
        return runner.tagDocument;
    }

    public List<WeightedTag> getPopularCloud(final CoreSession session, final DocumentModel document) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<WeightedTag>>(){

            public List<WeightedTag> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getPopularCloud(em, session, document);
            }
        });
    }

    public List<WeightedTag> getPopularCloud(EntityManager em, CoreSession session, DocumentModel document) throws ClientException {
        if (null == document) {
            throw new ClientException("Can't get cloud for domain null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going for popular cloud for " + document.getTitle()));
        }
        String query = String.format("SELECT * FROM Document WHERE ecm:path STARTSWITH '%s' AND ecm:isProxy = %d", document.getPathAsString(), this.config.isQueryingForProxy() ? 1 : 0);
        UnrestrictedSessionRunQuery runner = new UnrestrictedSessionRunQuery(session, query);
        runner.runUnrestricted();
        runner.result.add((Object)document);
        return TaggingProvider.createProvider(em).getPopularCloud(runner.result, TagServiceImpl.getUserName(session));
    }

    public List<WeightedTag> getPopularCloudOnAllDocuments(final CoreSession session) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<WeightedTag>>(){

            public List<WeightedTag> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getPopularCloudOnAllDocuments(em, session);
            }
        });
    }

    public List<WeightedTag> getPopularCloudOnAllDocuments(EntityManager em, CoreSession session) throws ClientException {
        return TaggingProvider.createProvider(em).getPopularCloudOnAllDocuments(TagServiceImpl.getUserName(session));
    }

    public WeightedTag getPopularTag(final CoreSession session, final DocumentModel document, final String tagId) throws ClientException {
        return (WeightedTag)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<WeightedTag>(){

            public WeightedTag runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getPopularTag(em, session, document, tagId);
            }
        });
    }

    public WeightedTag getPopularTag(EntityManager em, CoreSession session, DocumentModel document, String tagId) throws ClientException {
        if (null == document || null == tagId) {
            throw new ClientException("Can't get popular for document or tag null.");
        }
        String user = TagServiceImpl.getUserName(session);
        DocumentModel tag = session.getDocument((DocumentRef)new IdRef(tagId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to look for popularity of " + tag.getTitle() + " for " + document.getTitle()));
        }
        if (!TagServiceImpl.isTagAllowed(tag, user)) {
            log.warn((Object)("Tag " + tag.getTitle() + " not allowed for " + user));
            return new WeightedTag(tag.getId(), tag.getTitle(), 0);
        }
        return new WeightedTag(tag.getId(), (String)((Object)tag.getPropertyValue("tag:label")), 0);
    }

    public List<WeightedTag> getVoteCloud(final CoreSession session, final DocumentModel document) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<WeightedTag>>(){

            public List<WeightedTag> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getVoteCloud(em, session, document);
            }
        });
    }

    public List<WeightedTag> getVoteCloud(EntityManager em, CoreSession session, DocumentModel document) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public WeightedTag getVoteTag(final CoreSession session, final DocumentModel document, final String tagId) throws ClientException {
        return (WeightedTag)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<WeightedTag>(){

            public WeightedTag runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getVoteTag(em, session, document, tagId);
            }
        });
    }

    public WeightedTag getVoteTag(EntityManager em, CoreSession session, DocumentModel document, String tagId) throws ClientException {
        if (null == document) {
            throw new ClientException("Can't get list of documents from domain null.");
        }
        String user = TagServiceImpl.getUserName(session);
        DocumentModel tag = session.getDocument((DocumentRef)new IdRef(tagId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to look for votes of " + tag.getTitle() + " for " + document.getTitle()));
        }
        if (!TagServiceImpl.isTagAllowed(tag, user)) {
            log.warn((Object)("Tag " + tag.getTitle() + " not allowed for " + user));
            return new WeightedTag(tag.getId(), tag.getTitle(), 0);
        }
        TaggingProvider taggingProvider = TaggingProvider.createProvider(em);
        Long result = taggingProvider.getVoteTag(document.getId(), tag.getId(), user);
        return new WeightedTag(tag.getId(), (String)((Object)tag.getPropertyValue("tag:label")), result.intValue());
    }

    public List<Tag> listTagsAppliedOnDocument(final CoreSession session, final DocumentModel document) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Tag>>(){

            public List<Tag> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.listTagsAppliedOnDocument(em, session, document);
            }
        });
    }

    public List<Tag> listTagsAppliedOnDocument(EntityManager em, CoreSession session, DocumentModel document) throws ClientException {
        if (null == document) {
            throw new ClientException("Can't get list of tags from group null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to look for tags applied on " + document.getTitle()));
        }
        return TaggingProvider.createProvider(em).listTagsForDocument(document.getId(), TagServiceImpl.getUserName(session));
    }

    public List<Tag> listTagsAppliedOnDocumentByUser(final CoreSession session, final DocumentModel document) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Tag>>(){

            public List<Tag> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.listTagsAppliedOnDocumentByUser(em, session, document);
            }
        });
    }

    public List<Tag> listTagsAppliedOnDocumentByUser(EntityManager em, CoreSession session, DocumentModel document) throws ClientException {
        if (null == document) {
            throw new ClientException("Can't get list of tags from group null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to look only current user tags applied on " + document.getTitle()));
        }
        return TaggingProvider.createProvider(em).listTagsForDocumentAndUser(document.getId(), TagServiceImpl.getUserName(session));
    }

    public DocumentModelList listTagsInGroup(final CoreSession session, final DocumentModel tag) throws ClientException {
        return (DocumentModelList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<DocumentModelList>(){

            public DocumentModelList runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.listTagsInGroup(em, session, tag);
            }
        });
    }

    public DocumentModelList listTagsInGroup(DocumentModel tag) throws ClientException {
        return this.listTagsInGroup(tag.getCoreSession(), tag);
    }

    public DocumentModelList listTagsInGroup(EntityManager em, CoreSession session, DocumentModel tag) throws ClientException {
        if (null == tag) {
            throw new ClientException("Can't get list of tags from group null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to list tags in " + tag.getTitle()));
        }
        String user = TagServiceImpl.getUserName(session);
        String query = String.format("SELECT * FROM Tag WHERE ecm:path STARTSWITH '%s' AND (tag:private = 0 or dc:creator = '%s') AND ecm:isProxy = %d", tag.getPathAsString(), user, this.config.isQueryingForProxy() ? 1 : 0);
        UnrestrictedSessionRunQuery runner = new UnrestrictedSessionRunQuery(session, query);
        runner.runUnrestricted();
        return runner.result;
    }

    public void untagDocument(final CoreSession session, final DocumentModel document, final String tagId) throws ClientException {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) throws ClientException {
                TagServiceImpl.this.untagDocument(em, session, document, tagId);
            }
        });
    }

    public void untagDocument(EntityManager em, CoreSession session, DocumentModel document, String tagId) throws ClientException {
        if (null == document || tagId == null) {
            throw new ClientException("Can't untag document or tag null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to untag " + tagId + " for " + document.getTitle()));
        }
        TaggingProvider.createProvider(em).removeTagging(document.getId(), tagId, TagServiceImpl.getUserName(session));
    }

    public void completeUntagDocument(final CoreSession session, final DocumentModel document, final String tagId) throws ClientException {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) throws ClientException {
                TagServiceImpl.this.completeUntagDocument(em, session, document, tagId);
            }
        });
    }

    public void completeUntagDocument(EntityManager em, CoreSession session, DocumentModel document, String tagId) throws ClientException {
        if (null == document || tagId == null) {
            throw new ClientException("Can't untag document or tag null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to untag " + tagId + " for " + document.getTitle()));
        }
        TaggingProvider.createProvider(em).removeAllTagging(document.getId(), tagId);
    }

    public List<String> listDocumentsForTag(final CoreSession session, final String tagId, final String user) throws ClientException {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<String>>(){

            public List<String> runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.listDocumentsForTag(em, session, tagId, user);
            }
        });
    }

    public List<String> listDocumentsForTag(EntityManager em, CoreSession session, String tagId, String user) throws ClientException {
        if (null == tagId) {
            throw new ClientException("Can't get list of documents for tag null.");
        }
        return TaggingProvider.createProvider(em).getDocumentsForTag(tagId, user);
    }

    protected static boolean isTagAllowed(DocumentModel tag, String user) throws ClientException {
        if (tag == null) {
            throw new ClientException("Can't get list of documents from tag null.");
        }
        Long isPrivate = (Long)tag.getPropertyValue("tag:private");
        if (isPrivate == null || isPrivate == 0L) {
            return true;
        }
        String owner = (String)((Object)tag.getPropertyValue("dc:creator"));
        return user != null && user.equals(owner);
    }

    protected static DocumentModel createTagModel(CoreSession session, DocumentModel parent, String label, String user, boolean privateFlag) throws ClientException {
        DocumentModel tagDocument = session.createDocumentModel(parent.getPathAsString(), IdUtils.generateId((String)label), "Tag");
        tagDocument = session.createDocument(tagDocument);
        tagDocument.setPropertyValue("dc:title", (Serializable)((Object)label));
        tagDocument.setPropertyValue("dc:description", (Serializable)((Object)""));
        tagDocument.setPropertyValue("dc:created", (Serializable)Calendar.getInstance());
        tagDocument.setPropertyValue("dc:creator", (Serializable)((Object)user));
        tagDocument.setPropertyValue("tag:label", (Serializable)((Object)label));
        tagDocument.setPropertyValue("tag:private", (Serializable)Integer.valueOf(privateFlag ? 1 : 0));
        tagDocument = session.saveDocument(tagDocument);
        session.save();
        return tagDocument;
    }

    public String getTaggingId(final CoreSession session, final String docId, final String tagLabel, final String author) throws ClientException {
        return (String)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<String>(){

            public String runWith(EntityManager em) throws ClientException {
                return TagServiceImpl.this.getTaggingId(em, session, docId, tagLabel, author);
            }
        });
    }

    public String getTaggingId(EntityManager em, CoreSession session, String docId, String tagLabel, String author) {
        return TaggingProvider.createProvider(em).getTaggingId(docId, tagLabel, author);
    }

    public void updateSchema() {
        HibernateConfigurator configurator = (HibernateConfigurator)Framework.getLocalService(HibernateConfigurator.class);
        HibernateConfiguration configuration = configurator.getHibernateConfiguration("nxtags");
        TagSchemaUpdater updater = new TagSchemaUpdater(configuration.hibernateProperties);
        updater.update();
    }

    public boolean isEnabled() {
        if (enabled == null) {
            this.checkEnable();
        }
        return enabled;
    }

    protected static class UnrestrictedSessionRunQuery
    extends UnrestrictedSessionRunner {
        public DocumentModelList result;
        private final String query;

        public UnrestrictedSessionRunQuery(CoreSession session, String query) {
            super(session);
            this.query = query;
            this.result = null;
        }

        public void run() throws ClientException {
            this.result = this.session.query(this.query);
        }
    }

    protected class UnrestrictedSessionCreateTag
    extends UnrestrictedSessionRunner {
        public DocumentModel tagDocument;
        private final DocumentModel parent;
        private final String label;
        private final String user;
        private final boolean privateFlag;

        public UnrestrictedSessionCreateTag(CoreSession session, DocumentModel parent, String label, boolean privateFlag) throws ClientException {
            super(session);
            this.parent = parent;
            this.tagDocument = null;
            this.label = label;
            this.user = TagServiceImpl.getUserName(session);
            this.privateFlag = privateFlag;
        }

        public void run() throws ClientException {
            String[] labels = this.label.split("/");
            DocumentModel relativeParent = this.parent;
            for (String atomicLabel : labels) {
                String query = String.format("SELECT * FROM Tag WHERE ecm:parentId = '%s' AND tag:label = '%s' AND ecm:isProxy = %d", relativeParent.getId(), atomicLabel, TagServiceImpl.this.config.queryProxy ? 1 : 0);
                DocumentModelList tags = this.session.query(query);
                DocumentModel foundTag = null;
                if (tags != null && tags.size() > 0) {
                    for (DocumentModel aTag : tags) {
                        Long isPrivate = (Long)aTag.getPropertyValue("tag:private");
                        if (isPrivate == null || isPrivate == 0L) {
                            foundTag = aTag;
                            break;
                        }
                        String tagUser = (String)((Object)aTag.getPropertyValue("dc:creator"));
                        if (!this.user.equals(tagUser)) continue;
                        foundTag = aTag;
                        break;
                    }
                }
                relativeParent = foundTag != null ? foundTag : TagServiceImpl.createTagModel(this.session, relativeParent, atomicLabel, this.user, this.privateFlag);
            }
            this.tagDocument = relativeParent;
            ((DocumentModelImpl)this.tagDocument).detach(true);
        }
    }

    protected static class UnrestrictedSessionCreateRootTag
    extends UnrestrictedSessionRunner {
        public String rootTagDocumentId = null;

        public UnrestrictedSessionCreateRootTag(CoreSession session) {
            super(session);
        }

        public void run() throws ClientException {
            DocumentModel documentRoot = this.session.getRootDocument();
            DocumentModelList rootHiddenChildren = this.session.getChildren(documentRoot.getRef(), "HiddenFolder");
            if (null != rootHiddenChildren) {
                for (DocumentModel hiddenFolder : rootHiddenChildren) {
                    if (!"Tags".equals(hiddenFolder.getTitle())) continue;
                    this.rootTagDocumentId = hiddenFolder.getId();
                    return;
                }
            }
        }
    }
}

