/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.Calendar;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;

public class TagServiceInitializer
extends RepositoryInitializationHandler {
    public void doInitializeRepository(CoreSession session) throws ClientException {
        Path rootTagPath = new Path(session.getRootDocument().getPathAsString());
        String rootTagName = IdUtils.generateId((String)"Tags");
        if (!session.exists((DocumentRef)new PathRef((rootTagPath = rootTagPath.append(rootTagName)).toString()))) {
            DocumentModel rootTag = session.createDocumentModel(session.getRootDocument().getPathAsString(), rootTagName, "HiddenFolder");
            rootTag.setPropertyValue("dc:title", (Serializable)((Object)"Tags"));
            rootTag.setPropertyValue("dc:description", (Serializable)((Object)""));
            rootTag.setPropertyValue("dc:created", (Serializable)Calendar.getInstance());
            rootTag = session.createDocument(rootTag);
            rootTag = session.saveDocument(rootTag);
            ACE ace = new ACE("Everyone", "Read", true);
            ACLImpl acl = new ACLImpl();
            acl.add((Object)ace);
            ACPImpl acp = new ACPImpl();
            acp.addACL((ACL)acl);
            session.setACP(rootTag.getRef(), (ACP)acp, true);
            session.save();
        }
    }
}

