/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.nuxeo.ecm.platform.tag.entity.DublincoreEntity;
import org.nuxeo.ecm.platform.tag.entity.TagEntity;

@Entity(name="Tagging")
@Table(name="NXP_TAGGING")
@NamedQueries(value={@NamedQuery(name="listTagsForDocument", query="SELECT DISTINCT tag.id, tag.label FROM Tagging tagging JOIN tagging.tag tag JOIN tag.hierarchy h JOIN h.dublincore dc WHERE (tagging.isPrivate=0 OR tagging.author=:userName) AND (tag.private1 = 0 OR dc.creator = :userName) AND tagging.targetDocument.id = :targetId"), @NamedQuery(name="listTagsForDocumentAndUser", query="SELECT DISTINCT tagging.id, tag.label FROM Tagging tagging JOIN tagging.tag tag JOIN tag.hierarchy h JOIN h.dublincore dc WHERE tagging.author=:userName AND (tag.private1 = 0 OR dc.creator = :userName) AND tagging.targetDocument.id = :targetId"), @NamedQuery(name="getVoteTag", query="SELECT COUNT(tagging) FROM Tagging tagging WHERE tagging.targetDocument.id=:targetId AND tagging.tag.id=:tagId AND (tagging.isPrivate=0 OR tagging.author=:userName) "), @NamedQuery(name="removeTagging", query="DELETE FROM Tagging tagging WHERE tagging.targetDocument.id=:targetId AND tagging.author=:userName AND tagging.tag.id=:tagId"), @NamedQuery(name="getVoteCloud", query="SELECT tag.id, tag.label, COUNT(tag.id) FROM Tagging tg JOIN tg.tag tag JOIN tag.hierarchy h JOIN h.dublincore dc WHERE tg.targetDocument.id IN (:listOfIds) AND (tg.isPrivate=0 OR tg.author=:userName) AND (tg.tag.private1 = 0 OR dc.creator = :userName) GROUP BY tag.id , tag.label"), @NamedQuery(name="listDocumentsForTag", query="SELECT DISTINCT tagging.targetDocument.id FROM Tagging tagging WHERE (tagging.isPrivate=0 OR tagging.author=:userName) AND tagging.tag.id = :tagId"), @NamedQuery(name="getTagging", query="SELECT COUNT(tagging.id) FROM Tagging tagging WHERE tagging.tag.id = :tagId AND tagging.targetDocument.id = :docId AND tagging.author = :userName")})
public class TaggingEntity
implements Serializable {
    private static final long serialVersionUID = -1091703195187974444L;
    @Id
    @Column(name="ID", nullable=false)
    private String id;
    @ManyToOne(optional=false)
    @JoinColumn(name="DOCUMENT_ID", nullable=false, updatable=false)
    private DublincoreEntity targetDocument;
    @ManyToOne(optional=false)
    @JoinColumn(name="TAG_ID", nullable=false, updatable=false)
    private TagEntity tag;
    @Column(name="AUTHOR")
    private String author;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATION_DATE")
    private Date creationDate;
    @Column(name="IS_PRIVATE", columnDefinition="integer", precision=1)
    private int isPrivate = 0;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public int getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(int isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setTargetDocument(DublincoreEntity targetDocument) {
        this.targetDocument = targetDocument;
    }

    public DublincoreEntity getTargetDocument() {
        return this.targetDocument;
    }

    public void setTag(TagEntity tag) {
        this.tag = tag;
    }

    public TagEntity getTag() {
        return this.tag;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("Tagging: id - ");
        ret.append(this.id);
        ret.append("; target - ");
        if (this.targetDocument != null) {
            ret.append(this.targetDocument.getId());
        } else {
            ret.append("null");
        }
        ret.append("; tag - ");
        if (this.tag != null) {
            ret.append(this.tag.getLabel());
        } else {
            ret.append("null");
        }
        return ret.toString();
    }
}

