/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.persistence;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.hibernate.impl.SessionImpl;
import org.nuxeo.ecm.platform.tag.sql.Column;
import org.nuxeo.ecm.platform.tag.sql.Table;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.xml.sax.EntityResolver;

public class TagSchemaUpdater {
    public static final Log log = LogFactory.getLog(TagSchemaUpdater.class);
    public final AnnotationConfiguration configuration = new AnnotationConfiguration();
    public final PersistenceMetadata metadata = this.doLoadMetadata();
    public final Properties connectionProperties = new Properties();

    public TagSchemaUpdater() {
        this.doSetup();
    }

    public TagSchemaUpdater(Properties properties) {
        this.connectionProperties.putAll((Map<?, ?>)properties);
        this.doSetup();
    }

    protected void doSetup() {
        this.doSetupAnnotedClasses();
        this.doSetupConnectionProperties();
    }

    protected void doSetupAnnotedClasses() {
        for (String mappedClassName : this.metadata.getClasses()) {
            try {
                this.configuration.addAnnotatedClass(Class.forName(mappedClassName));
            }
            catch (Exception e) {
                throw new Error("Cannot load class " + mappedClassName, e);
            }
        }
    }

    protected void doSetupConnectionProperties() {
        if (this.connectionProperties.get("hibernate.connection.url") != null) {
            return;
        }
        String jtaDatasource = this.metadata.getJtaDatasource();
        this.connectionProperties.setProperty("hibernate.connection.datasource", jtaDatasource);
    }

    protected PersistenceMetadata doLoadMetadata() {
        Enumeration<URL> xmls;
        try {
            xmls = TagSchemaUpdater.class.getClassLoader().getResources("META-INF/persistence.xml");
        }
        catch (IOException e1) {
            throw new Error("No persistence.xml files in class path", e1);
        }
        while (xmls.hasMoreElements()) {
            URL url = xmls.nextElement();
            List metadataFiles = null;
            try {
                metadataFiles = PersistenceXmlLoader.deploy((URL)url, (Map)Collections.EMPTY_MAP, (EntityResolver)this.configuration.getEntityResolver());
            }
            catch (Exception e) {
                log.warn((Object)("Cannot load " + url));
                continue;
            }
            for (PersistenceMetadata metadata : metadataFiles) {
                if (!metadata.getName().equals("nxtags")) continue;
                return metadata;
            }
        }
        throw new Error("cannot find nxtags persistence unit");
    }

    public static Dialect determineDialect(SessionImpl session) {
        try {
            DatabaseMetaData meta = session.getFactory().getConnectionProvider().getConnection().getMetaData();
            return DialectFactory.determineDialect((String)meta.getDatabaseProductName(), (int)meta.getDatabaseMajorVersion());
        }
        catch (SQLException e) {
            throw new Error("Cannot determine dialect", e);
        }
    }

    public void update() {
        String dataSource = this.connectionProperties.getProperty("hibernate.connection.datasource");
        if (dataSource != null) {
            dataSource = DataSourceHelper.getDataSourceJNDIName((String)dataSource);
            this.connectionProperties.setProperty("hibernate.connection.datasource", dataSource);
        }
        this.configuration.setProperties(this.connectionProperties);
        Settings settings = this.configuration.buildSettings();
        Table table = new Table("NXP_TAGGING");
        Column column = new Column("ID", 12);
        column.setPrimary(true);
        column.setNullable(false);
        table.addColumn(column);
        column = new Column("TAG_ID", 12);
        table.addColumn(column);
        column = new Column("AUTHOR", 12);
        table.addColumn(column);
        column = new Column("DOCUMENT_ID", 12);
        table.addColumn(column);
        column = new Column("CREATION_DATE", 91);
        table.addColumn(column);
        column = new Column("IS_PRIVATE", 4);
        table.addColumn(column);
        Dialect dialect = settings.getDialect();
        String script = table.getCreateSql(dialect);
        try {
            ResultSet result;
            Connection connection = settings.getConnectionProvider().getConnection();
            String name = table.getName();
            DatabaseMetaData md = connection.getMetaData();
            if (!md.storesUpperCaseIdentifiers()) {
                name = name.toLowerCase();
            }
            if (!(result = md.getTables(null, null, name, null)).next()) {
                log.debug((Object)"creating TagService tables");
                Statement statement = connection.createStatement();
                statement.execute(script);
            } else {
                log.debug((Object)"TagService tables already exist");
            }
        }
        catch (SQLException e) {
            throw new Error("Cannot update schema", e);
        }
    }
}

