/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.ecm.platform.tag.entity.DublincoreEntity;
import org.nuxeo.ecm.platform.tag.entity.TagEntity;
import org.nuxeo.ecm.platform.tag.entity.TaggingEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingProvider {
    private static final Log log = LogFactory.getLog(TaggingProvider.class);
    protected final EntityManager em;

    protected TaggingProvider(EntityManager em) {
        this.em = em;
    }

    public static TaggingProvider createProvider(EntityManager em) {
        return new TaggingProvider(em);
    }

    public void addTagging(TaggingEntity tagging) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addTagging() with tagging " + tagging.toString()));
        }
        this.em.persist((Object)tagging);
    }

    protected List doQuery(String query, List params) {
        Query q = this.em.createQuery(query);
        for (int i = 0; i < params.size(); ++i) {
            q.setParameter(i + 1, params.get(i));
        }
        return q.getResultList();
    }

    protected List<?> doQuery(String query, Object ... params) {
        Query q = this.em.createQuery(query);
        for (int i = 0; i < params.length; ++i) {
            q.setParameter(i + 1, params[i]);
        }
        return q.getResultList();
    }

    protected List<?> doNamedQuery(String namedQuery, Map<String, Object> params) {
        Query query = this.em.createNamedQuery(namedQuery);
        for (String key : params.keySet()) {
            query.setParameter(key, params.get(key));
        }
        return query.getResultList();
    }

    protected Object doNamedQuerySingle(String namedQuery, Map<String, Object> params) {
        Query query = this.em.createNamedQuery(namedQuery);
        for (String key : params.keySet()) {
            query.setParameter(key, params.get(key));
        }
        return query.getSingleResult();
    }

    public void addTaggingEntries(List<TaggingEntity> taggings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addTaggingEntries() for " + taggings.size() + " entries"));
        }
        for (TaggingEntity taggin : taggings) {
            this.addTagging(taggin);
        }
    }

    public List<Tag> listTagsForDocument(String docId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listTagsForDocument() with Id " + docId));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", docId);
        params.put("userName", userName);
        List<?> queryResults = this.doNamedQuery("listTagsForDocument", params);
        ArrayList<Tag> listTagsForDocument = new ArrayList<Tag>();
        for (Object[] queryResult : queryResults) {
            listTagsForDocument.add(new Tag(queryResult[0].toString(), queryResult[1].toString()));
        }
        return listTagsForDocument;
    }

    public String getTaggingId(String docId, String tagLabel, String author) {
        String query = "SELECT tg.id FROM Tagging tg JOIN tg.targetDocument doc JOIN tg.tag tag WHERE doc.id = ?1 AND tag.label = ?2 AND tg.author = ?3";
        List<?> authors = this.doQuery("SELECT tg.id FROM Tagging tg JOIN tg.targetDocument doc JOIN tg.tag tag WHERE doc.id = ?1 AND tag.label = ?2 AND tg.author = ?3", docId, tagLabel, author);
        return authors.size() > 0 ? (String)authors.get(0) : null;
    }

    public List<Tag> listTagsForDocumentAndUser(String docId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("listTagsForDocumentAndUser() with Id " + docId));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", docId);
        params.put("userName", userName);
        List<?> queryResults = this.doNamedQuery("listTagsForDocumentAndUser", params);
        ArrayList<Tag> listTagsForDocument = new ArrayList<Tag>();
        for (Object[] queryResult : queryResults) {
            listTagsForDocument.add(new Tag(queryResult[0].toString(), queryResult[1].toString()));
        }
        return listTagsForDocument;
    }

    public Long getVoteTag(String docId, String tagId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVoteTag() for " + docId + " and " + tagId));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", docId);
        params.put("userName", userName);
        params.put("tagId", tagId);
        return (Long)this.doNamedQuerySingle("getVoteTag", params);
    }

    public boolean removeTagging(String docId, String tagId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTagging() with targetId " + docId + " and tagId " + tagId));
        }
        Query query = this.em.createNamedQuery("removeTagging");
        query.setParameter("targetId", (Object)docId);
        query.setParameter("tagId", (Object)tagId);
        query.setParameter("userName", (Object)userName);
        int result = query.executeUpdate();
        return result == 1;
    }

    public void removeAllTagging(String docId, String tagId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTagging() with targetId " + docId + " and tagId " + tagId));
        }
        Query query = this.em.createQuery("DELETE FROM Tagging tagging WHERE tagging.targetDocument.id=:targetId AND tagging.tag.id=:tagId");
        query.setParameter("targetId", (Object)docId);
        query.setParameter("tagId", (Object)tagId);
        query.executeUpdate();
    }

    public TagEntity getTagById(String tagId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTagById() with id " + tagId));
        }
        return (TagEntity)this.em.find(TagEntity.class, (Object)tagId);
    }

    public DublincoreEntity getDcById(String docId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDcById() with id " + docId));
        }
        return (DublincoreEntity)this.em.find(DublincoreEntity.class, (Object)docId);
    }

    public List<WeightedTag> getPopularCloud(DocumentModelList documents, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPopularTag() for " + documents.size() + " documents"));
        }
        int count = 1;
        StringBuilder sb = new StringBuilder("SELECT tag.id, tag.label, COUNT(DISTINCT tg.targetDocument.id) FROM Tagging tg JOIN tg.tag tag JOIN tag.hierarchy h JOIN h.dublincore dc WHERE tg.targetDocument.id IN ( ");
        LinkedList<String> params = new LinkedList<String>();
        for (DocumentModel document : documents) {
            params.add(document.getId());
            sb.append('?').append(count).append(count < documents.size() ? "," : "");
            ++count;
        }
        sb.append(") AND (tg.isPrivate=0 OR tg.author=?");
        sb.append(count);
        sb.append(") AND ");
        sb.append("(tg.tag.private1=0 OR dc.creator=?");
        sb.append(++count);
        ++count;
        sb.append(") GROUP BY tag.id , tag.label");
        params.add(userName);
        params.add(userName);
        List queryResults = this.doQuery(sb.toString(), params);
        ArrayList<WeightedTag> ret = new ArrayList<WeightedTag>();
        for (Object[] queryResult : queryResults) {
            WeightedTag weightedTag = new WeightedTag((String)queryResult[0], (String)queryResult[1], ((Long)queryResult[2]).intValue());
            ret.add(weightedTag);
        }
        return ret;
    }

    public List<WeightedTag> getPopularCloudOnAllDocuments(String userName) {
        LinkedList<String> params = new LinkedList<String>();
        StringBuilder sb = new StringBuilder("SELECT tag.id, tag.label, COUNT(DISTINCT tg.targetDocument.id) FROM Tagging tg JOIN tg.tag tag JOIN tag.hierarchy h JOIN h.dublincore dc WHERE ");
        sb.append(" (tg.isPrivate=0 OR tg.author=");
        sb.append("?1");
        sb.append(") AND ");
        sb.append("(tg.tag.private1 = 0 OR dc.creator = ");
        sb.append("?2");
        sb.append(") GROUP BY tag.id , tag.label");
        params.add(userName);
        params.add(userName);
        List queryResults = this.doQuery(sb.toString(), params);
        ArrayList<WeightedTag> ret = new ArrayList<WeightedTag>();
        for (Object[] queryResult : queryResults) {
            WeightedTag weightedTag = new WeightedTag((String)queryResult[0], (String)queryResult[1], ((Long)queryResult[2]).intValue());
            ret.add(weightedTag);
        }
        return ret;
    }

    public List<String> getDocumentsForTag(String tagId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDocumentsForTag() with Id " + tagId));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userName", userName);
        params.put("tagId", tagId);
        List<?> queryResults = this.doNamedQuery("listDocumentsForTag", params);
        ArrayList<String> ret = new ArrayList<String>();
        for (Object queryResult : queryResults) {
            ret.add(queryResult.toString());
        }
        return ret;
    }

    public boolean existTagging(String tagId, String docId, String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("existTagging() with " + tagId + ", " + docId + ", " + userName));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("docId", docId);
        params.put("userName", userName);
        params.put("tagId", tagId);
        Long result = (Long)this.doNamedQuerySingle("getTagging", params);
        return result > 0L;
    }
}

